package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 单据批量删除接口ReturnBillDataRequest
 */
@ApiModel(description = "单据批量删除接口ReturnBillDataRequest")

@JsonInclude(NON_NULL)
public class EntityObj {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("url")
    private String url = null;

    @JsonProperty("serialNumber")
    private String serialNumber = null;

    @JsonIgnore
    public EntityObj billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code集合
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code集合")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public EntityObj url(String url) {
        this.url = url;
        return this;
    }

    /**
     * url
     *
     * @return url
     **/
    @ApiModelProperty(value = "url")
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonIgnore
    public EntityObj serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    /**
     * 流水号
     *
     * @return serialNumber
     **/
    @ApiModelProperty(value = "流水号")
    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EntityObj entityObj = (EntityObj) o;
        return Objects.equals(this.billCode, entityObj.billCode) &&
            Objects.equals(this.url, entityObj.url) &&
            Objects.equals(this.serialNumber, entityObj.serialNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, url, serialNumber);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityObj {\n");

        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
