package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 获取认领单证数据Request
 */
@ApiModel(description = "获取认领单证数据Request")

@JsonInclude(NON_NULL)
public class GetClaimTicketListRequest extends PageRequest {

    @JsonProperty("isPublic")
    private Integer isPublic = null;

    @JsonIgnore
    public GetClaimTicketListRequest isPublic(Integer isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    /**
     * 是否公共:0-否，1-是
     *
     * @return isPublic
     **/
    @ApiModelProperty(value = "是否公共:0-否，1-是")
    public Integer getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(Integer isPublic) {
        this.isPublic = isPublic;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetClaimTicketListRequest getClaimTicketListRequest = (GetClaimTicketListRequest) o;
        return Objects.equals(this.isPublic, getClaimTicketListRequest.isPublic) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isPublic, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetClaimTicketListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
