package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 影像表Request
 */
@ApiModel(description = "影像表Request")

@JsonInclude(NON_NULL)
public class GetImageListRequest extends PageRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("exceptionStatus")
    private Integer exceptionStatus = null;

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonProperty("invoiceType")
    private String invoiceType = null;

    @JsonProperty("scene")
    private String scene = null;

    @JsonProperty("ticketParams")
    private Map<String, String> ticketParams = new HashMap<>();

    @JsonProperty("imageIds")
    private List<Long> imageIds;

    public List<Long> getImageIds() {
        return imageIds;
    }

    public void setImageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
    }

    @JsonIgnore
    public GetImageListRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public GetImageListRequest exceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
        return this;
    }

    /**
     * 异常状态：0-无异常，1-异常，2-预警
     *
     * @return exceptionStatus
     **/
    @ApiModelProperty(value = "异常状态：0-无异常，1-异常，2-预警")
    public Integer getExceptionStatus() {
        return exceptionStatus;
    }

    public void setExceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    @JsonIgnore
    public GetImageListRequest pageCode(String pageCode) {
        this.pageCode = pageCode;
        return this;
    }

    /**
     * 页面code
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "页面code")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    @ApiModelProperty(value = "发票类型")
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetImageListRequest getImageListRequest = (GetImageListRequest) o;
        return Objects.equals(this.billCode, getImageListRequest.billCode) &&
            Objects.equals(this.exceptionStatus, getImageListRequest.exceptionStatus) &&
            Objects.equals(this.pageCode, getImageListRequest.pageCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, exceptionStatus, pageCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetImageListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    exceptionStatus: ").append(toIndentedString(exceptionStatus)).append("\n");
        sb.append("    pageCode: ").append(toIndentedString(pageCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Map<String, String> getTicketParams() {
        return ticketParams;
    }

    public void setTicketParams(Map<String, String> ticketParams) {
        this.ticketParams = ticketParams;
    }

}
