package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 影像表Request
 */
@ApiModel(description = "影像表Request")

@JsonInclude(NON_NULL)
public class GetImageReturnListRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("returnReason")
    private Integer returnReason = null;

    @JsonIgnore
    public GetImageReturnListRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public GetImageReturnListRequest returnReason(Integer returnReason) {
        this.returnReason = returnReason;
        return this;
    }

    /**
     * 退回原因
     *
     * @return returnReason
     **/
    @ApiModelProperty(value = "退回原因")
    public Integer getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(Integer returnReason) {
        this.returnReason = returnReason;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetImageReturnListRequest getImageReturnListRequest = (GetImageReturnListRequest) o;
        return Objects.equals(this.billCode, getImageReturnListRequest.billCode) &&
            Objects.equals(this.returnReason, getImageReturnListRequest.returnReason) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, returnReason, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetImageReturnListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    returnReason: ").append(toIndentedString(returnReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
