package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 物流明细Request
 */
@ApiModel(description = "物流明细Request")

@JsonInclude(NON_NULL)
public class GetLogisticsItemListRequest extends PageRequest {

    @JsonProperty("logisticsItemId")
    private Long logisticsItemId = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("logisticsId")
    private Long logisticsId = null;

    @JsonProperty("logisticsType")
    private Integer logisticsType = null;

    @JsonProperty("relId")
    private Long relId = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonIgnore
    public GetLogisticsItemListRequest logisticsItemId(Long logisticsItemId) {
        this.logisticsItemId = logisticsItemId;
        return this;
    }

    /**
     * 自增主键
     *
     * @return logisticsItemId
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getLogisticsItemId() {
        return logisticsItemId;
    }

    public void setLogisticsItemId(Long logisticsItemId) {
        this.logisticsItemId = logisticsItemId;
    }

    @JsonIgnore
    public GetLogisticsItemListRequest tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public GetLogisticsItemListRequest logisticsId(Long logisticsId) {
        this.logisticsId = logisticsId;
        return this;
    }

    /**
     * 物流表
     *
     * @return logisticsId
     **/
    @ApiModelProperty(value = "物流表")
    public Long getLogisticsId() {
        return logisticsId;
    }

    public void setLogisticsId(Long logisticsId) {
        this.logisticsId = logisticsId;
    }

    @JsonIgnore
    public GetLogisticsItemListRequest logisticsType(Integer logisticsType) {
        this.logisticsType = logisticsType;
        return this;
    }

    /**
     * 物流类型：0-未分配，1-单据，2-票证
     *
     * @return logisticsType
     **/
    @ApiModelProperty(value = "物流类型：0-未分配，1-单据，2-票证")
    public Integer getLogisticsType() {
        return logisticsType;
    }

    public void setLogisticsType(Integer logisticsType) {
        this.logisticsType = logisticsType;
    }

    @JsonIgnore
    public GetLogisticsItemListRequest relId(Long relId) {
        this.relId = relId;
        return this;
    }

    /**
     * 关联的单据或票证ID
     *
     * @return relId
     **/
    @ApiModelProperty(value = "关联的单据或票证ID")
    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    @JsonIgnore
    public GetLogisticsItemListRequest createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public GetLogisticsItemListRequest createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public GetLogisticsItemListRequest createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetLogisticsItemListRequest getLogisticsItemListRequest = (GetLogisticsItemListRequest) o;
        return Objects.equals(this.logisticsItemId, getLogisticsItemListRequest.logisticsItemId) &&
            Objects.equals(this.tenantId, getLogisticsItemListRequest.tenantId) &&
            Objects.equals(this.logisticsId, getLogisticsItemListRequest.logisticsId) &&
            Objects.equals(this.logisticsType, getLogisticsItemListRequest.logisticsType) &&
            Objects.equals(this.relId, getLogisticsItemListRequest.relId) &&
            Objects.equals(this.createTime, getLogisticsItemListRequest.createTime) &&
            Objects.equals(this.createUserId, getLogisticsItemListRequest.createUserId) &&
            Objects.equals(this.createUserName, getLogisticsItemListRequest.createUserName) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(logisticsItemId, tenantId, logisticsId, logisticsType, relId, createTime, createUserId, createUserName, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetLogisticsItemListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    logisticsItemId: ").append(toIndentedString(logisticsItemId)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    logisticsId: ").append(toIndentedString(logisticsId)).append("\n");
        sb.append("    logisticsType: ").append(toIndentedString(logisticsType)).append("\n");
        sb.append("    relId: ").append(toIndentedString(relId)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
