package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * 单据认领单证请求
 */
@ApiModel(description = "单据认领单证请求")

@JsonInclude(NON_NULL)
public class HookTicketRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("parentImageId")
    private Long parentImageId = null;

    @JsonProperty("hookTicketObjList")
    private List<HookTicketObj> hookTicketObjList = new ArrayList<HookTicketObj>();

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonProperty("scene")
    private String scene = null;

    private JSONObject ext = new JSONObject();

    @JsonIgnore
    public HookTicketRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public HookTicketRequest parentImageId(Long parentImageId) {
        this.parentImageId = parentImageId;
        return this;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    /**
     * 页面Code
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "页面Code")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    /**
     * 父影像id
     *
     * @return parentImageId
     **/
    @ApiModelProperty(value = "父影像id")
    public Long getParentImageId() {
        return parentImageId;
    }

    public void setParentImageId(Long parentImageId) {
        this.parentImageId = parentImageId;
    }

    public List<HookTicketObj> getHookTicketObjList() {
        return hookTicketObjList;
    }

    public void setHookTicketObjList(List<HookTicketObj> hookTicketObjList) {
        this.hookTicketObjList = hookTicketObjList;
    }

    public JSONObject getExt() {
        return ext;
    }

    public void setExt(JSONObject ext) {
        this.ext = ext;
    }

}
