package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.annotation.Description;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 影像表
 */
@ApiModel(description = "影像表")

@JsonInclude(NON_NULL)
@Data
public class ImageDTO {

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("imageCategory")
    private Integer imageCategory = null;

    @JsonProperty("imageType")
    private Integer imageType = null;

    @JsonProperty("imageSource")
    private String imageSource = null;

    @JsonProperty("requireOcrFlag")
    private Integer requireOcrFlag = null;

    @JsonProperty("fileUrl")
    private String fileUrl = null;

    @JsonProperty("fileUrlHandle")
    private String fileUrlHandle = null;

    @JsonProperty("fileUrlOrigin")
    private String fileUrlOrigin = null;

    @JsonProperty("fileType")
    private String fileType = null;

    @JsonProperty("fileTypeHandle")
    private String fileTypeHandle = null;

    @JsonProperty("billSeq")
    private Long billSeq = null;

    @JsonProperty("fileOrder")
    private String fileOrder = null;

    @JsonProperty("fileLevel")
    private Integer fileLevel = null;

    @JsonProperty("recStatus")
    private Integer recStatus = null;

    @JsonProperty("taskId")
    private String taskId = null;

    @JsonProperty("copyCount")
    private Integer copyCount = null;

    @JsonProperty("recStartTime")
    private Long recStartTime = null;

    @JsonProperty("recEndTime")
    private Long recEndTime = null;

    @JsonProperty("billImageId")
    private Long billImageId = null;

    @JsonProperty("ticketImageId")
    private Long ticketImageId = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("isManualUnhook")
    private Integer isManualUnhook = null;

    @JsonProperty("isPublic")
    private Integer isPublic = null;

    @JsonProperty("exceptionStatus")
    private Integer exceptionStatus = null;

    @JsonProperty("returnStatus")
    private Integer returnStatus = null;

    @JsonProperty("returnReason")
    private Integer returnReason = null;

    @JsonProperty("returnRemark")
    private String returnRemark = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("reserved1")
    private String reserved1 = null;

    @JsonProperty("reserved2")
    private String reserved2 = null;

    @JsonProperty("reserved3")
    private String reserved3 = null;

    @JsonProperty("isReuse")
    private Integer isReuse = null;

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonProperty("billEntityCode")
    private String billEntityCode = null;

    @JsonProperty("createUserCode")
    private String createUserCode = null;

    @JsonProperty("moreFileUrl")
    private String moreFileUrl = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("warningInfo")
    private String warningInfo = null;

    @JsonProperty("relExceptionInfo")
    private String relExceptionInfo = null;

    @JsonProperty("relWarningInfo")
    private String relWarningInfo = null;

    @JsonProperty("isCommit")
    private Integer isCommit = null;

    @JsonProperty("commitUserId")
    private Long commitUserId = null;

    @JsonProperty("commitUserName")
    private String commitUserName = null;

    @JsonProperty("commitTime")
    private Long commitTime = null;

    @JsonProperty("isHang")
    private Integer isHang = null;

    @JsonProperty("returnType")
    private Integer returnType = null;

    @JsonProperty("fileName")
    private String fileName = null;

    @JsonProperty("orgId")
    private Long orgId = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    @JsonProperty("orgName")
    private String orgName = null;

    @JsonProperty("calculateStatus")
    private Integer calculateStatus = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("ticketName")
    private String ticketName = null;

    @JsonProperty("isAdd")
    private Integer isAdd = null;

    @JsonProperty("isChange")
    private Integer isChange = null;

    @JsonProperty("isReplace")
    private Integer isReplace = null;

    @JsonProperty("fileId")
    private Long fileId = null;

    @Description("稽核扫描匹配字段")
    private String compareScanMatchField;

    @Description("终审退回状态")
    private Integer auditBackStatus;

    @Description("含税金额")
    private String taxAmount;

    @Description("不含税金额")
    private String amountWithTax;

    @Description("流水号")
    private String serialNumber;

    @Description("已删除")
    private Boolean isDelete;

}
