package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class LogApiDTO {

    @JsonProperty("logId")
    private Long logId = null;

    @JsonProperty("number")
    private String number = null;

    @JsonProperty("methodCode")
    private String methodCode = null;

    @JsonProperty("systemType")
    private Integer systemType = null;

    @JsonProperty("sender")
    private String sender = null;

    @JsonProperty("receiver")
    private String receiver = null;

    @JsonProperty("methodUrl")
    private String methodUrl = null;

    @JsonProperty("methodName")
    private String methodName = null;

    @JsonProperty("methodDescription")
    private String methodDescription = null;

    @JsonProperty("params")
    private String params = null;

    @JsonProperty("result")
    private String result = null;

    @JsonProperty("isSuccess")
    private Integer isSuccess = null;

    @JsonProperty("isRetry")
    private Integer isRetry = null;

    @JsonProperty("exceptionDetail")
    private String exceptionDetail = null;

    @JsonProperty("executionTime")
    private String executionTime = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUser")
    private String createUser = null;

    @JsonIgnore
    public LogApiDTO logId(Long logId) {
        this.logId = logId;
        return this;
    }

    /**
     * null
     *
     * @return logId
     **/
    @ApiModelProperty(value = "null")
    public Long getLogId() {
        return logId;
    }

    public void setLogId(Long logId) {
        this.logId = logId;
    }

    @JsonIgnore
    public LogApiDTO number(String number) {
        this.number = number;
        return this;
    }

    /**
     * null
     *
     * @return number
     **/
    @ApiModelProperty(value = "null")
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @JsonIgnore
    public LogApiDTO methodCode(String methodCode) {
        this.methodCode = methodCode;
        return this;
    }

    /**
     * 方法code
     *
     * @return methodCode
     **/
    @ApiModelProperty(value = "方法code")
    public String getMethodCode() {
        return methodCode;
    }

    public void setMethodCode(String methodCode) {
        this.methodCode = methodCode;
    }

    @JsonIgnore
    public LogApiDTO systemType(Integer systemType) {
        this.systemType = systemType;
        return this;
    }

    /**
     * null
     *
     * @return systemType
     **/
    @ApiModelProperty(value = "null")
    public Integer getSystemType() {
        return systemType;
    }

    public void setSystemType(Integer systemType) {
        this.systemType = systemType;
    }

    @JsonIgnore
    public LogApiDTO sender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * null
     *
     * @return sender
     **/
    @ApiModelProperty(value = "null")
    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    @JsonIgnore
    public LogApiDTO receiver(String receiver) {
        this.receiver = receiver;
        return this;
    }

    /**
     * null
     *
     * @return receiver
     **/
    @ApiModelProperty(value = "null")
    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @JsonIgnore
    public LogApiDTO methodUrl(String methodUrl) {
        this.methodUrl = methodUrl;
        return this;
    }

    /**
     * null
     *
     * @return methodUrl
     **/
    @ApiModelProperty(value = "null")
    public String getMethodUrl() {
        return methodUrl;
    }

    public void setMethodUrl(String methodUrl) {
        this.methodUrl = methodUrl;
    }

    @JsonIgnore
    public LogApiDTO methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    /**
     * null
     *
     * @return methodName
     **/
    @ApiModelProperty(value = "null")
    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @JsonIgnore
    public LogApiDTO methodDescription(String methodDescription) {
        this.methodDescription = methodDescription;
        return this;
    }

    /**
     * null
     *
     * @return methodDescription
     **/
    @ApiModelProperty(value = "null")
    public String getMethodDescription() {
        return methodDescription;
    }

    public void setMethodDescription(String methodDescription) {
        this.methodDescription = methodDescription;
    }

    @JsonIgnore
    public LogApiDTO params(String params) {
        this.params = params;
        return this;
    }

    /**
     * null
     *
     * @return params
     **/
    @ApiModelProperty(value = "null")
    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    @JsonIgnore
    public LogApiDTO result(String result) {
        this.result = result;
        return this;
    }

    /**
     * null
     *
     * @return result
     **/
    @ApiModelProperty(value = "null")
    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @JsonIgnore
    public LogApiDTO isSuccess(Integer isSuccess) {
        this.isSuccess = isSuccess;
        return this;
    }

    /**
     * null
     *
     * @return isSuccess
     **/
    @ApiModelProperty(value = "null")
    public Integer getIsSuccess() {
        return isSuccess;
    }

    public void setIsSuccess(Integer isSuccess) {
        this.isSuccess = isSuccess;
    }

    @JsonIgnore
    public LogApiDTO isRetry(Integer isRetry) {
        this.isRetry = isRetry;
        return this;
    }

    /**
     * 是否重试 0-否 1-是
     *
     * @return isRetry
     **/
    @ApiModelProperty(value = "是否重试 0-否 1-是")
    public Integer getIsRetry() {
        return isRetry;
    }

    public void setIsRetry(Integer isRetry) {
        this.isRetry = isRetry;
    }

    @JsonIgnore
    public LogApiDTO exceptionDetail(String exceptionDetail) {
        this.exceptionDetail = exceptionDetail;
        return this;
    }

    /**
     * null
     *
     * @return exceptionDetail
     **/
    @ApiModelProperty(value = "null")
    public String getExceptionDetail() {
        return exceptionDetail;
    }

    public void setExceptionDetail(String exceptionDetail) {
        this.exceptionDetail = exceptionDetail;
    }

    @JsonIgnore
    public LogApiDTO executionTime(String executionTime) {
        this.executionTime = executionTime;
        return this;
    }

    /**
     * null
     *
     * @return executionTime
     **/
    @ApiModelProperty(value = "null")
    public String getExecutionTime() {
        return executionTime;
    }

    public void setExecutionTime(String executionTime) {
        this.executionTime = executionTime;
    }

    @JsonIgnore
    public LogApiDTO createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * null
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "null")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public LogApiDTO createUser(String createUser) {
        this.createUser = createUser;
        return this;
    }

    /**
     * null
     *
     * @return createUser
     **/
    @ApiModelProperty(value = "null")
    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogApiDTO logApiDTO = (LogApiDTO) o;
        return Objects.equals(this.logId, logApiDTO.logId) &&
            Objects.equals(this.number, logApiDTO.number) &&
            Objects.equals(this.methodCode, logApiDTO.methodCode) &&
            Objects.equals(this.systemType, logApiDTO.systemType) &&
            Objects.equals(this.sender, logApiDTO.sender) &&
            Objects.equals(this.receiver, logApiDTO.receiver) &&
            Objects.equals(this.methodUrl, logApiDTO.methodUrl) &&
            Objects.equals(this.methodName, logApiDTO.methodName) &&
            Objects.equals(this.methodDescription, logApiDTO.methodDescription) &&
            Objects.equals(this.params, logApiDTO.params) &&
            Objects.equals(this.result, logApiDTO.result) &&
            Objects.equals(this.isSuccess, logApiDTO.isSuccess) &&
            Objects.equals(this.isRetry, logApiDTO.isRetry) &&
            Objects.equals(this.exceptionDetail, logApiDTO.exceptionDetail) &&
            Objects.equals(this.executionTime, logApiDTO.executionTime) &&
            Objects.equals(this.createTime, logApiDTO.createTime) &&
            Objects.equals(this.createUser, logApiDTO.createUser);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(logId, number, methodCode, systemType, sender, receiver, methodUrl, methodName, methodDescription, params, result, isSuccess, isRetry, exceptionDetail, executionTime, createTime,
                createUser);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogApiDTO {\n");

        sb.append("    logId: ").append(toIndentedString(logId)).append("\n");
        sb.append("    number: ").append(toIndentedString(number)).append("\n");
        sb.append("    methodCode: ").append(toIndentedString(methodCode)).append("\n");
        sb.append("    systemType: ").append(toIndentedString(systemType)).append("\n");
        sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
        sb.append("    receiver: ").append(toIndentedString(receiver)).append("\n");
        sb.append("    methodUrl: ").append(toIndentedString(methodUrl)).append("\n");
        sb.append("    methodName: ").append(toIndentedString(methodName)).append("\n");
        sb.append("    methodDescription: ").append(toIndentedString(methodDescription)).append("\n");
        sb.append("    params: ").append(toIndentedString(params)).append("\n");
        sb.append("    result: ").append(toIndentedString(result)).append("\n");
        sb.append("    isSuccess: ").append(toIndentedString(isSuccess)).append("\n");
        sb.append("    isRetry: ").append(toIndentedString(isRetry)).append("\n");
        sb.append("    exceptionDetail: ").append(toIndentedString(exceptionDetail)).append("\n");
        sb.append("    executionTime: ").append(toIndentedString(executionTime)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
