package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class LogMqDTO {

    @JsonProperty("mqId")
    private Long mqId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("sender")
    private String sender = null;

    @JsonProperty("listener")
    private String listener = null;

    @JsonProperty("queueName")
    private String queueName = null;

    @JsonProperty("queueDesc")
    private String queueDesc = null;

    @JsonProperty("properties")
    private String properties = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("error")
    private String error = null;

    @JsonProperty("receiveTime")
    private Long receiveTime = null;

    @JsonProperty("finishTime")
    private Long finishTime = null;

    @JsonIgnore
    public LogMqDTO mqId(Long mqId) {
        this.mqId = mqId;
        return this;
    }

    /**
     * 主键
     *
     * @return mqId
     **/
    @ApiModelProperty(value = "主键")
    public Long getMqId() {
        return mqId;
    }

    public void setMqId(Long mqId) {
        this.mqId = mqId;
    }

    @JsonIgnore
    public LogMqDTO billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public LogMqDTO ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 票证号
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "票证号")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }

    @JsonIgnore
    public LogMqDTO sender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * 发送方
     *
     * @return sender
     **/
    @ApiModelProperty(value = "发送方")
    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    @JsonIgnore
    public LogMqDTO listener(String listener) {
        this.listener = listener;
        return this;
    }

    /**
     * 监听方
     *
     * @return listener
     **/
    @ApiModelProperty(value = "监听方")
    public String getListener() {
        return listener;
    }

    public void setListener(String listener) {
        this.listener = listener;
    }

    @JsonIgnore
    public LogMqDTO queueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    /**
     * 队列名
     *
     * @return queueName
     **/
    @ApiModelProperty(value = "队列名")
    public String getQueueName() {
        return queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @JsonIgnore
    public LogMqDTO queueDesc(String queueDesc) {
        this.queueDesc = queueDesc;
        return this;
    }

    /**
     * 队列描述
     *
     * @return queueDesc
     **/
    @ApiModelProperty(value = "队列描述")
    public String getQueueDesc() {
        return queueDesc;
    }

    public void setQueueDesc(String queueDesc) {
        this.queueDesc = queueDesc;
    }

    @JsonIgnore
    public LogMqDTO properties(String properties) {
        this.properties = properties;
        return this;
    }

    /**
     * 队列属性
     *
     * @return properties
     **/
    @ApiModelProperty(value = "队列属性")
    public String getProperties() {
        return properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @JsonIgnore
    public LogMqDTO message(String message) {
        this.message = message;
        return this;
    }

    /**
     * 队列消息
     *
     * @return message
     **/
    @ApiModelProperty(value = "队列消息")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public LogMqDTO status(Integer status) {
        this.status = status;
        return this;
    }

    /**
     * 状态：1-成功，0-失败
     *
     * @return status
     **/
    @ApiModelProperty(value = "状态：1-成功，0-失败")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonIgnore
    public LogMqDTO error(String error) {
        this.error = error;
        return this;
    }

    /**
     * 异常信息
     *
     * @return error
     **/
    @ApiModelProperty(value = "异常信息")
    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    @JsonIgnore
    public LogMqDTO receiveTime(Long receiveTime) {
        this.receiveTime = receiveTime;
        return this;
    }

    /**
     * 接收时间
     *
     * @return receiveTime
     **/
    @ApiModelProperty(value = "接收时间")
    public Long getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Long receiveTime) {
        this.receiveTime = receiveTime;
    }

    @JsonIgnore
    public LogMqDTO finishTime(Long finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    /**
     * 完成时间
     *
     * @return finishTime
     **/
    @ApiModelProperty(value = "完成时间")
    public Long getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Long finishTime) {
        this.finishTime = finishTime;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogMqDTO logMqDTO = (LogMqDTO) o;
        return Objects.equals(this.mqId, logMqDTO.mqId) &&
            Objects.equals(this.billCode, logMqDTO.billCode) &&
            Objects.equals(this.ticketCode, logMqDTO.ticketCode) &&
            Objects.equals(this.sender, logMqDTO.sender) &&
            Objects.equals(this.listener, logMqDTO.listener) &&
            Objects.equals(this.queueName, logMqDTO.queueName) &&
            Objects.equals(this.queueDesc, logMqDTO.queueDesc) &&
            Objects.equals(this.properties, logMqDTO.properties) &&
            Objects.equals(this.message, logMqDTO.message) &&
            Objects.equals(this.status, logMqDTO.status) &&
            Objects.equals(this.error, logMqDTO.error) &&
            Objects.equals(this.receiveTime, logMqDTO.receiveTime) &&
            Objects.equals(this.finishTime, logMqDTO.finishTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mqId, billCode, ticketCode, sender, listener, queueName, queueDesc, properties, message, status, error, receiveTime, finishTime);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogMqDTO {\n");

        sb.append("    mqId: ").append(toIndentedString(mqId)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
        sb.append("    listener: ").append(toIndentedString(listener)).append("\n");
        sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
        sb.append("    queueDesc: ").append(toIndentedString(queueDesc)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    error: ").append(toIndentedString(error)).append("\n");
        sb.append("    receiveTime: ").append(toIndentedString(receiveTime)).append("\n");
        sb.append("    finishTime: ").append(toIndentedString(finishTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
