package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * ModifyIsPrintedRequest
 */

@JsonInclude(NON_NULL)
public class ModifyIsPrintedRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("isPrinted")
    private Integer isPrinted = null;

    @JsonIgnore
    public ModifyIsPrintedRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public ModifyIsPrintedRequest isPrinted(Integer isPrinted) {
        this.isPrinted = isPrinted;
        return this;
    }

    /**
     * 是否已打印:0-否,1-是
     *
     * @return isPrinted
     **/
    @ApiModelProperty(value = "是否已打印:0-否,1-是")
    public Integer getIsPrinted() {
        return isPrinted;
    }

    public void setIsPrinted(Integer isPrinted) {
        this.isPrinted = isPrinted;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ModifyIsPrintedRequest modifyIsPrintedRequest = (ModifyIsPrintedRequest) o;
        return Objects.equals(this.billCode, modifyIsPrintedRequest.billCode) &&
            Objects.equals(this.isPrinted, modifyIsPrintedRequest.isPrinted) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, isPrinted, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModifyIsPrintedRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    isPrinted: ").append(toIndentedString(isPrinted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
