package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.util.Lists;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 票证明细标签数据Request
 */
@Data
@ApiModel(description = "票证明细标签数据Request")
@JsonInclude(NON_NULL)
public class SaveTicketDetailLabelsRequest extends BaseRequest {

    /**
     * 明细Id集合
     */
    @NotEmpty(message = "明细Id不能为空")
    @JsonProperty("ids")
    private List<Long> ids = Lists.newArrayList();

    /**
     * 明细对象代码
     */
    @NotNull(message = "单证明细代码不能为空")
    @JsonProperty("ticketDetailCode")
    private String ticketDetailCode;

    /**
     * 标签Id集合
     */
    @JsonProperty("labelIdList")
    private List<Long> labelIdList = Lists.newArrayList();

}
