package com.xforceplus.elephant.image.client.model;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

@Data
public class TicketBean extends TicketDTO implements Serializable {

    @ApiModelProperty("标签集合")
    private List<JSONObject> labelList = Lists.newArrayList();
    @ApiModelProperty("单证code名称")
    private String ticketCodeName = "";
    @ApiModelProperty("是否展示验真")
    private boolean showVerify = true;
    @ApiModelProperty("是否展示验签")
    private boolean showSign = true;
    @ApiModelProperty("是否校验非增票权限")
    private int isCheckNVatPermission;

    public List<JSONObject> getLabelList() {
        return labelList;
    }

    public void setLabelList(List<JSONObject> labelList) {
        this.labelList = labelList;
    }

    public String getTicketCodeName() {
        return ticketCodeName;
    }

    public void setTicketCodeName(String ticketCodeName) {
        this.ticketCodeName = ticketCodeName;
    }

    public boolean isShowVerify() {
        return showVerify;
    }

    public void setShowVerify(boolean showVerify) {
        this.showVerify = showVerify;
    }

    public boolean isShowSign() {
        return showSign;
    }

    public void setShowSign(boolean showSign) {
        this.showSign = showSign;
    }

}
