package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * 票证数据
 */
@ApiModel(description = "票证数据")

@JsonInclude(NON_NULL)
public class TicketInvoiceDTO {

    @JsonProperty("ticketDataId")
    private Long ticketDataId = null;

    @JsonProperty("ticketDataType")
    private String ticketDataType = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("warningStatus")
    private Integer warningStatus = null;

    @JsonProperty("warningInfo")
    private String warningInfo = null;

    @JsonProperty("exceptionStatus")
    private Integer exceptionStatus = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("checkStatus")
    private Integer checkStatus = null;

    @JsonProperty("checkRemark")
    private String checkRemark = null;

    @JsonProperty("checkTaskId")
    private String checkTaskId = null;

    @JsonProperty("checkRequestTime")
    private Long checkRequestTime = null;

    @JsonProperty("checkResponseTime")
    private Long checkResponseTime = null;

    @JsonProperty("checkUserId")
    private Long checkUserId = null;

    @JsonProperty("checkUserName")
    private String checkUserName = null;

    @JsonProperty("isHooked")
    private Integer isHooked = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("ticketCreateTime")
    private Long ticketCreateTime = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("invoiceSheet")
    private Integer invoiceSheet = null;

    @JsonProperty("purchaserName")
    private String purchaserName = null;

    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;

    @JsonProperty("sellerName")
    private String sellerName = null;

    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;

    @JsonProperty("paperDrewDate")
    private String paperDrewDate = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("checkCode")
    private String checkCode = null;

    @JsonIgnore
    public TicketInvoiceDTO ticketDataId(Long ticketDataId) {
        this.ticketDataId = ticketDataId;
        return this;
    }

    /**
     * 自增主键
     *
     * @return ticketDataId
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getTicketDataId() {
        return ticketDataId;
    }

    public void setTicketDataId(Long ticketDataId) {
        this.ticketDataId = ticketDataId;
    }

    @JsonIgnore
    public TicketInvoiceDTO ticketDataType(String ticketDataType) {
        this.ticketDataType = ticketDataType;
        return this;
    }

    /**
     * 单证类型：s-增值税专用发票,d-多票，f-附件
     *
     * @return ticketDataType
     **/
    @ApiModelProperty(value = "单证类型：s-增值税专用发票,d-多票，f-附件")
    public String getTicketDataType() {
        return ticketDataType;
    }

    public void setTicketDataType(String ticketDataType) {
        this.ticketDataType = ticketDataType;
    }

    @JsonIgnore
    public TicketInvoiceDTO tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public TicketInvoiceDTO imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public TicketInvoiceDTO billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public TicketInvoiceDTO batchNo(String batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    /**
     * 扫描批次号
     *
     * @return batchNo
     **/
    @ApiModelProperty(value = "扫描批次号")
    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public TicketInvoiceDTO warningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
        return this;
    }

    /**
     * 预警状态：0-否，1-是
     *
     * @return warningStatus
     **/
    @ApiModelProperty(value = "预警状态：0-否，1-是")
    public Integer getWarningStatus() {
        return warningStatus;
    }

    public void setWarningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
    }

    @JsonIgnore
    public TicketInvoiceDTO warningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
        return this;
    }

    /**
     * 预警信息
     *
     * @return warningInfo
     **/
    @ApiModelProperty(value = "预警信息")
    public String getWarningInfo() {
        return warningInfo;
    }

    public void setWarningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
    }

    @JsonIgnore
    public TicketInvoiceDTO exceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
        return this;
    }

    /**
     * 异常状态：0-否，1-是
     *
     * @return exceptionStatus
     **/
    @ApiModelProperty(value = "异常状态：0-否，1-是")
    public Integer getExceptionStatus() {
        return exceptionStatus;
    }

    public void setExceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    @JsonIgnore
    public TicketInvoiceDTO exceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    /**
     * 异常信息
     *
     * @return exceptionInfo
     **/
    @ApiModelProperty(value = "异常信息")
    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    @JsonIgnore
    public TicketInvoiceDTO checkStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
        return this;
    }

    /**
     * 验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败
     *
     * @return checkStatus
     **/
    @ApiModelProperty(value = "验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败")
    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    @JsonIgnore
    public TicketInvoiceDTO checkRemark(String checkRemark) {
        this.checkRemark = checkRemark;
        return this;
    }

    /**
     * 验真备注
     *
     * @return checkRemark
     **/
    @ApiModelProperty(value = "验真备注")
    public String getCheckRemark() {
        return checkRemark;
    }

    public void setCheckRemark(String checkRemark) {
        this.checkRemark = checkRemark;
    }

    @JsonIgnore
    public TicketInvoiceDTO checkTaskId(String checkTaskId) {
        this.checkTaskId = checkTaskId;
        return this;
    }

    /**
     * 验真任务ID
     *
     * @return checkTaskId
     **/
    @ApiModelProperty(value = "验真任务ID")
    public String getCheckTaskId() {
        return checkTaskId;
    }

    public void setCheckTaskId(String checkTaskId) {
        this.checkTaskId = checkTaskId;
    }

    @JsonIgnore
    public TicketInvoiceDTO checkRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
        return this;
    }

    /**
     * 验真请求时间
     *
     * @return checkRequestTime
     **/
    @ApiModelProperty(value = "验真请求时间")
    public Long getCheckRequestTime() {
        return checkRequestTime;
    }

    public void setCheckRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
    }

    @JsonIgnore
    public TicketInvoiceDTO checkResponseTime(Long checkResponseTime) {
        this.checkResponseTime = checkResponseTime;
        return this;
    }

    /**
     * 验真返回时间
     *
     * @return checkResponseTime
     **/
    @ApiModelProperty(value = "验真返回时间")
    public Long getCheckResponseTime() {
        return checkResponseTime;
    }

    public void setCheckResponseTime(Long checkResponseTime) {
        this.checkResponseTime = checkResponseTime;
    }

    @JsonIgnore
    public TicketInvoiceDTO checkUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
        return this;
    }

    /**
     * 验真人ID
     *
     * @return checkUserId
     **/
    @ApiModelProperty(value = "验真人ID")
    public Long getCheckUserId() {
        return checkUserId;
    }

    public void setCheckUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
    }

    @JsonIgnore
    public TicketInvoiceDTO checkUserName(String checkUserName) {
        this.checkUserName = checkUserName;
        return this;
    }

    /**
     * 验真人姓名
     *
     * @return checkUserName
     **/
    @ApiModelProperty(value = "验真人姓名")
    public String getCheckUserName() {
        return checkUserName;
    }

    public void setCheckUserName(String checkUserName) {
        this.checkUserName = checkUserName;
    }

    @JsonIgnore
    public TicketInvoiceDTO isHooked(Integer isHooked) {
        this.isHooked = isHooked;
        return this;
    }

    /**
     * 是否已挂接：0-否，1-是
     *
     * @return isHooked
     **/
    @ApiModelProperty(value = "是否已挂接：0-否，1-是")
    public Integer getIsHooked() {
        return isHooked;
    }

    public void setIsHooked(Integer isHooked) {
        this.isHooked = isHooked;
    }

    @JsonIgnore
    public TicketInvoiceDTO createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public TicketInvoiceDTO createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUser() {
        return createUserId;
    }

    public void setCreateUser(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public TicketInvoiceDTO createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public TicketInvoiceDTO updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public TicketInvoiceDTO updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public TicketInvoiceDTO updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @JsonIgnore
    public TicketInvoiceDTO ticketCreateTime(Long ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
        return this;
    }

    /**
     * 上传时间
     *
     * @return ticketCreateTime
     **/
    @ApiModelProperty(value = "上传时间")
    public Long getTicketCreateTime() {
        return ticketCreateTime;
    }

    public void setTicketCreateTime(Long ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
    }

    @JsonIgnore
    public TicketInvoiceDTO invoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
        return this;
    }

    /**
     * 发票号码
     *
     * @return invoiceNo
     **/
    @ApiModelProperty(value = "发票号码")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @JsonIgnore
    public TicketInvoiceDTO invoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
        return this;
    }

    /**
     * 发票代码
     *
     * @return invoiceCode
     **/
    @ApiModelProperty(value = "发票代码")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @JsonIgnore
    public TicketInvoiceDTO invoiceSheet(Integer invoiceSheet) {
        this.invoiceSheet = invoiceSheet;
        return this;
    }

    /**
     * 发票联次：1-发票联，2-抵扣联
     *
     * @return invoiceSheet
     **/
    @ApiModelProperty(value = "发票联次：1-发票联，2-抵扣联")
    public Integer getInvoiceSheet() {
        return invoiceSheet;
    }

    public void setInvoiceSheet(Integer invoiceSheet) {
        this.invoiceSheet = invoiceSheet;
    }

    @JsonIgnore
    public TicketInvoiceDTO purchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
        return this;
    }

    /**
     * 购方公司
     *
     * @return purchaserName
     **/
    @ApiModelProperty(value = "购方公司")
    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    @JsonIgnore
    public TicketInvoiceDTO purchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
        return this;
    }

    /**
     * 购方税号
     *
     * @return purchaserTaxNo
     **/
    @ApiModelProperty(value = "购方税号")
    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    @JsonIgnore
    public TicketInvoiceDTO sellerName(String sellerName) {
        this.sellerName = sellerName;
        return this;
    }

    /**
     * 销方名称
     *
     * @return sellerName
     **/
    @ApiModelProperty(value = "销方名称")
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    @JsonIgnore
    public TicketInvoiceDTO sellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
        return this;
    }

    /**
     * 销方税号
     *
     * @return sellerTaxNo
     **/
    @ApiModelProperty(value = "销方税号")
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    @JsonIgnore
    public TicketInvoiceDTO paperDrewDate(String paperDrewDate) {
        this.paperDrewDate = paperDrewDate;
        return this;
    }

    /**
     * 开票日期
     *
     * @return paperDrewDate
     **/
    @ApiModelProperty(value = "开票日期")
    public String getPaperDrewDate() {
        return paperDrewDate;
    }

    public void setPaperDrewDate(String paperDrewDate) {
        this.paperDrewDate = paperDrewDate;
    }

    @JsonIgnore
    public TicketInvoiceDTO amountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
        return this;
    }

    /**
     * 含税金额
     *
     * @return amountWithTax
     **/
    @ApiModelProperty(value = "含税金额")
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @JsonIgnore
    public TicketInvoiceDTO taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    /**
     * 税额
     *
     * @return taxAmount
     **/
    @ApiModelProperty(value = "税额")
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @JsonIgnore
    public TicketInvoiceDTO amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    /**
     * 不含税金额
     *
     * @return amountWithoutTax
     **/
    @ApiModelProperty(value = "不含税金额")
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public TicketInvoiceDTO checkCode(String checkCode) {
        this.checkCode = checkCode;
        return this;
    }

    /**
     * 校验码
     *
     * @return checkCode
     **/
    @ApiModelProperty(value = "校验码")
    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketInvoiceDTO ticketInvoiceDTO = (TicketInvoiceDTO) o;
        return Objects.equals(this.ticketDataId, ticketInvoiceDTO.ticketDataId) &&
            Objects.equals(this.ticketDataType, ticketInvoiceDTO.ticketDataType) &&
            Objects.equals(this.tenantId, ticketInvoiceDTO.tenantId) &&
            Objects.equals(this.imageId, ticketInvoiceDTO.imageId) &&
            Objects.equals(this.billCode, ticketInvoiceDTO.billCode) &&
            Objects.equals(this.batchNo, ticketInvoiceDTO.batchNo) &&
            Objects.equals(this.warningStatus, ticketInvoiceDTO.warningStatus) &&
            Objects.equals(this.warningInfo, ticketInvoiceDTO.warningInfo) &&
            Objects.equals(this.exceptionStatus, ticketInvoiceDTO.exceptionStatus) &&
            Objects.equals(this.exceptionInfo, ticketInvoiceDTO.exceptionInfo) &&
            Objects.equals(this.checkStatus, ticketInvoiceDTO.checkStatus) &&
            Objects.equals(this.checkRemark, ticketInvoiceDTO.checkRemark) &&
            Objects.equals(this.checkTaskId, ticketInvoiceDTO.checkTaskId) &&
            Objects.equals(this.checkRequestTime, ticketInvoiceDTO.checkRequestTime) &&
            Objects.equals(this.checkResponseTime, ticketInvoiceDTO.checkResponseTime) &&
            Objects.equals(this.checkUserId, ticketInvoiceDTO.checkUserId) &&
            Objects.equals(this.checkUserName, ticketInvoiceDTO.checkUserName) &&
            Objects.equals(this.isHooked, ticketInvoiceDTO.isHooked) &&
            Objects.equals(this.createTime, ticketInvoiceDTO.createTime) &&
            Objects.equals(this.createUserId, ticketInvoiceDTO.createUserId) &&
            Objects.equals(this.createUserName, ticketInvoiceDTO.createUserName) &&
            Objects.equals(this.updateTime, ticketInvoiceDTO.updateTime) &&
            Objects.equals(this.updateUserId, ticketInvoiceDTO.updateUserId) &&
            Objects.equals(this.updateUserName, ticketInvoiceDTO.updateUserName) &&
            Objects.equals(this.ticketCreateTime, ticketInvoiceDTO.ticketCreateTime) &&
            Objects.equals(this.invoiceNo, ticketInvoiceDTO.invoiceNo) &&
            Objects.equals(this.invoiceCode, ticketInvoiceDTO.invoiceCode) &&
            Objects.equals(this.invoiceSheet, ticketInvoiceDTO.invoiceSheet) &&
            Objects.equals(this.purchaserName, ticketInvoiceDTO.purchaserName) &&
            Objects.equals(this.purchaserTaxNo, ticketInvoiceDTO.purchaserTaxNo) &&
            Objects.equals(this.sellerName, ticketInvoiceDTO.sellerName) &&
            Objects.equals(this.sellerTaxNo, ticketInvoiceDTO.sellerTaxNo) &&
            Objects.equals(this.paperDrewDate, ticketInvoiceDTO.paperDrewDate) &&
            Objects.equals(this.amountWithTax, ticketInvoiceDTO.amountWithTax) &&
            Objects.equals(this.taxAmount, ticketInvoiceDTO.taxAmount) &&
            Objects.equals(this.amountWithoutTax, ticketInvoiceDTO.amountWithoutTax) &&
            Objects.equals(this.checkCode, ticketInvoiceDTO.checkCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketDataId, ticketDataType, tenantId, imageId, billCode, batchNo, warningStatus, warningInfo, exceptionStatus, exceptionInfo, checkStatus, checkRemark, checkTaskId,
            checkRequestTime, checkResponseTime, checkUserId, checkUserName, isHooked, createTime, createUserId, createUserName, updateTime, updateUserId, updateUserName, ticketCreateTime, invoiceNo,
            invoiceCode, invoiceSheet, purchaserName, purchaserTaxNo, sellerName, sellerTaxNo, paperDrewDate, amountWithTax, taxAmount, amountWithoutTax, checkCode);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TicketInvoiceDTO {\n");

        sb.append("    ticketDataId: ").append(toIndentedString(ticketDataId)).append("\n");
        sb.append("    ticketDataType: ").append(toIndentedString(ticketDataType)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
        sb.append("    warningStatus: ").append(toIndentedString(warningStatus)).append("\n");
        sb.append("    warningInfo: ").append(toIndentedString(warningInfo)).append("\n");
        sb.append("    exceptionStatus: ").append(toIndentedString(exceptionStatus)).append("\n");
        sb.append("    exceptionInfo: ").append(toIndentedString(exceptionInfo)).append("\n");
        sb.append("    checkStatus: ").append(toIndentedString(checkStatus)).append("\n");
        sb.append("    checkRemark: ").append(toIndentedString(checkRemark)).append("\n");
        sb.append("    checkTaskId: ").append(toIndentedString(checkTaskId)).append("\n");
        sb.append("    checkRequestTime: ").append(toIndentedString(checkRequestTime)).append("\n");
        sb.append("    checkResponseTime: ").append(toIndentedString(checkResponseTime)).append("\n");
        sb.append("    checkUserId: ").append(toIndentedString(checkUserId)).append("\n");
        sb.append("    checkUserName: ").append(toIndentedString(checkUserName)).append("\n");
        sb.append("    isHooked: ").append(toIndentedString(isHooked)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("    ticketCreateTime: ").append(toIndentedString(ticketCreateTime)).append("\n");
        sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
        sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
        sb.append("    invoiceSheet: ").append(toIndentedString(invoiceSheet)).append("\n");
        sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
        sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
        sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
        sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
        sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
        sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
        sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
        sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
        sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
