package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 票证数据
 */
@ApiModel(description = "票证数据")

@JsonInclude(NON_NULL)
public class TicketManyDTO {

    @JsonProperty("ticketDataId")
    private Long ticketDataId = null;

    @JsonProperty("ticketDataType")
    private String ticketDataType = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("warningStatus")
    private Integer warningStatus = null;

    @JsonProperty("warningInfo")
    private String warningInfo = null;

    @JsonProperty("exceptionStatus")
    private Integer exceptionStatus = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("checkStatus")
    private Integer checkStatus = null;

    @JsonProperty("checkRemark")
    private String checkRemark = null;

    @JsonProperty("checkTaskId")
    private String checkTaskId = null;

    @JsonProperty("checkRequestTime")
    private Long checkRequestTime = null;

    @JsonProperty("checkResponseTime")
    private Long checkResponseTime = null;

    @JsonProperty("checkUserId")
    private Long checkUserId = null;

    @JsonProperty("checkUserName")
    private String checkUserName = null;

    @JsonProperty("isHooked")
    private Integer isHooked = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("ticketCreateTime")
    private Long ticketCreateTime = null;

    @JsonProperty("imageNum")
    private Integer imageNum = null;

    @JsonProperty("exceptionNum")
    private Integer exceptionNum = null;

    @JsonProperty("warningNum")
    private Integer warningNum = null;

    @JsonIgnore
    public TicketManyDTO ticketDataId(Long ticketDataId) {
        this.ticketDataId = ticketDataId;
        return this;
    }

    /**
     * 自增主键
     *
     * @return ticketDataId
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getTicketDataId() {
        return ticketDataId;
    }

    public void setTicketDataId(Long ticketDataId) {
        this.ticketDataId = ticketDataId;
    }

    @JsonIgnore
    public TicketManyDTO ticketDataType(String ticketDataType) {
        this.ticketDataType = ticketDataType;
        return this;
    }

    /**
     * 单证类型：s-增值税专用发票,d-多票，f-附件
     *
     * @return ticketDataType
     **/
    @ApiModelProperty(value = "单证类型：s-增值税专用发票,d-多票，f-附件")
    public String getTicketDataType() {
        return ticketDataType;
    }

    public void setTicketDataType(String ticketDataType) {
        this.ticketDataType = ticketDataType;
    }

    @JsonIgnore
    public TicketManyDTO tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public TicketManyDTO imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public TicketManyDTO billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public TicketManyDTO batchNo(String batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    /**
     * 扫描批次号
     *
     * @return batchNo
     **/
    @ApiModelProperty(value = "扫描批次号")
    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public TicketManyDTO warningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
        return this;
    }

    /**
     * 预警状态：0-否，1-是
     *
     * @return warningStatus
     **/
    @ApiModelProperty(value = "预警状态：0-否，1-是")
    public Integer getWarningStatus() {
        return warningStatus;
    }

    public void setWarningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
    }

    @JsonIgnore
    public TicketManyDTO warningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
        return this;
    }

    /**
     * 预警信息
     *
     * @return warningInfo
     **/
    @ApiModelProperty(value = "预警信息")
    public String getWarningInfo() {
        return warningInfo;
    }

    public void setWarningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
    }

    @JsonIgnore
    public TicketManyDTO exceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
        return this;
    }

    /**
     * 异常状态：0-否，1-是
     *
     * @return exceptionStatus
     **/
    @ApiModelProperty(value = "异常状态：0-否，1-是")
    public Integer getExceptionStatus() {
        return exceptionStatus;
    }

    public void setExceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    @JsonIgnore
    public TicketManyDTO exceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    /**
     * 异常信息
     *
     * @return exceptionInfo
     **/
    @ApiModelProperty(value = "异常信息")
    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    @JsonIgnore
    public TicketManyDTO checkStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
        return this;
    }

    /**
     * 验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败
     *
     * @return checkStatus
     **/
    @ApiModelProperty(value = "验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败")
    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    @JsonIgnore
    public TicketManyDTO checkRemark(String checkRemark) {
        this.checkRemark = checkRemark;
        return this;
    }

    /**
     * 验真备注
     *
     * @return checkRemark
     **/
    @ApiModelProperty(value = "验真备注")
    public String getCheckRemark() {
        return checkRemark;
    }

    public void setCheckRemark(String checkRemark) {
        this.checkRemark = checkRemark;
    }

    @JsonIgnore
    public TicketManyDTO checkTaskId(String checkTaskId) {
        this.checkTaskId = checkTaskId;
        return this;
    }

    /**
     * 验真任务ID
     *
     * @return checkTaskId
     **/
    @ApiModelProperty(value = "验真任务ID")
    public String getCheckTaskId() {
        return checkTaskId;
    }

    public void setCheckTaskId(String checkTaskId) {
        this.checkTaskId = checkTaskId;
    }

    @JsonIgnore
    public TicketManyDTO checkRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
        return this;
    }

    /**
     * 验真请求时间
     *
     * @return checkRequestTime
     **/
    @ApiModelProperty(value = "验真请求时间")
    public Long getCheckRequestTime() {
        return checkRequestTime;
    }

    public void setCheckRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
    }

    @JsonIgnore
    public TicketManyDTO checkResponseTime(Long checkResponseTime) {
        this.checkResponseTime = checkResponseTime;
        return this;
    }

    /**
     * 验真返回时间
     *
     * @return checkResponseTime
     **/
    @ApiModelProperty(value = "验真返回时间")
    public Long getCheckResponseTime() {
        return checkResponseTime;
    }

    public void setCheckResponseTime(Long checkResponseTime) {
        this.checkResponseTime = checkResponseTime;
    }

    @JsonIgnore
    public TicketManyDTO checkUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
        return this;
    }

    /**
     * 验真人ID
     *
     * @return checkUserId
     **/
    @ApiModelProperty(value = "验真人ID")
    public Long getCheckUserId() {
        return checkUserId;
    }

    public void setCheckUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
    }

    @JsonIgnore
    public TicketManyDTO checkUserName(String checkUserName) {
        this.checkUserName = checkUserName;
        return this;
    }

    /**
     * 验真人姓名
     *
     * @return checkUserName
     **/
    @ApiModelProperty(value = "验真人姓名")
    public String getCheckUserName() {
        return checkUserName;
    }

    public void setCheckUserName(String checkUserName) {
        this.checkUserName = checkUserName;
    }

    @JsonIgnore
    public TicketManyDTO isHooked(Integer isHooked) {
        this.isHooked = isHooked;
        return this;
    }

    /**
     * 是否已挂接：0-否，1-是
     *
     * @return isHooked
     **/
    @ApiModelProperty(value = "是否已挂接：0-否，1-是")
    public Integer getIsHooked() {
        return isHooked;
    }

    public void setIsHooked(Integer isHooked) {
        this.isHooked = isHooked;
    }

    @JsonIgnore
    public TicketManyDTO createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public TicketManyDTO createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUser() {
        return createUserId;
    }

    public void setCreateUser(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public TicketManyDTO createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public TicketManyDTO updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public TicketManyDTO updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public TicketManyDTO updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @JsonIgnore
    public TicketManyDTO ticketCreateTime(Long ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
        return this;
    }

    /**
     * 上传时间
     *
     * @return ticketCreateTime
     **/
    @ApiModelProperty(value = "上传时间")
    public Long getTicketCreateTime() {
        return ticketCreateTime;
    }

    public void setTicketCreateTime(Long ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
    }

    @JsonIgnore
    public TicketManyDTO imageNum(Integer imageNum) {
        this.imageNum = imageNum;
        return this;
    }

    /**
     * 影像识别数
     *
     * @return imageNum
     **/
    @ApiModelProperty(value = "影像识别数")
    public Integer getImageNum() {
        return imageNum;
    }

    public void setImageNum(Integer imageNum) {
        this.imageNum = imageNum;
    }

    @JsonIgnore
    public TicketManyDTO exceptionNum(Integer exceptionNum) {
        this.exceptionNum = exceptionNum;
        return this;
    }

    /**
     * 异常数
     *
     * @return exceptionNum
     **/
    @ApiModelProperty(value = "异常数")
    public Integer getExceptionNum() {
        return exceptionNum;
    }

    public void setExceptionNum(Integer exceptionNum) {
        this.exceptionNum = exceptionNum;
    }

    @JsonIgnore
    public TicketManyDTO warningNum(Integer warningNum) {
        this.warningNum = warningNum;
        return this;
    }

    /**
     * 预警数
     *
     * @return warningNum
     **/
    @ApiModelProperty(value = "预警数")
    public Integer getWarningNum() {
        return warningNum;
    }

    public void setWarningNum(Integer warningNum) {
        this.warningNum = warningNum;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketManyDTO ticketManyDTO = (TicketManyDTO) o;
        return Objects.equals(this.ticketDataId, ticketManyDTO.ticketDataId) &&
            Objects.equals(this.ticketDataType, ticketManyDTO.ticketDataType) &&
            Objects.equals(this.tenantId, ticketManyDTO.tenantId) &&
            Objects.equals(this.imageId, ticketManyDTO.imageId) &&
            Objects.equals(this.billCode, ticketManyDTO.billCode) &&
            Objects.equals(this.batchNo, ticketManyDTO.batchNo) &&
            Objects.equals(this.warningStatus, ticketManyDTO.warningStatus) &&
            Objects.equals(this.warningInfo, ticketManyDTO.warningInfo) &&
            Objects.equals(this.exceptionStatus, ticketManyDTO.exceptionStatus) &&
            Objects.equals(this.exceptionInfo, ticketManyDTO.exceptionInfo) &&
            Objects.equals(this.checkStatus, ticketManyDTO.checkStatus) &&
            Objects.equals(this.checkRemark, ticketManyDTO.checkRemark) &&
            Objects.equals(this.checkTaskId, ticketManyDTO.checkTaskId) &&
            Objects.equals(this.checkRequestTime, ticketManyDTO.checkRequestTime) &&
            Objects.equals(this.checkResponseTime, ticketManyDTO.checkResponseTime) &&
            Objects.equals(this.checkUserId, ticketManyDTO.checkUserId) &&
            Objects.equals(this.checkUserName, ticketManyDTO.checkUserName) &&
            Objects.equals(this.isHooked, ticketManyDTO.isHooked) &&
            Objects.equals(this.createTime, ticketManyDTO.createTime) &&
            Objects.equals(this.createUserId, ticketManyDTO.createUserId) &&
            Objects.equals(this.createUserName, ticketManyDTO.createUserName) &&
            Objects.equals(this.updateTime, ticketManyDTO.updateTime) &&
            Objects.equals(this.updateUserId, ticketManyDTO.updateUserId) &&
            Objects.equals(this.updateUserName, ticketManyDTO.updateUserName) &&
            Objects.equals(this.ticketCreateTime, ticketManyDTO.ticketCreateTime) &&
            Objects.equals(this.imageNum, ticketManyDTO.imageNum) &&
            Objects.equals(this.exceptionNum, ticketManyDTO.exceptionNum) &&
            Objects.equals(this.warningNum, ticketManyDTO.warningNum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketDataId, ticketDataType, tenantId, imageId, billCode, batchNo, warningStatus, warningInfo, exceptionStatus, exceptionInfo, checkStatus, checkRemark, checkTaskId,
            checkRequestTime, checkResponseTime, checkUserId, checkUserName, isHooked, createTime, createUserId, createUserName, updateTime, updateUserId, updateUserName, ticketCreateTime, imageNum,
            exceptionNum, warningNum);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TicketManyDTO {\n");

        sb.append("    ticketDataId: ").append(toIndentedString(ticketDataId)).append("\n");
        sb.append("    ticketDataType: ").append(toIndentedString(ticketDataType)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
        sb.append("    warningStatus: ").append(toIndentedString(warningStatus)).append("\n");
        sb.append("    warningInfo: ").append(toIndentedString(warningInfo)).append("\n");
        sb.append("    exceptionStatus: ").append(toIndentedString(exceptionStatus)).append("\n");
        sb.append("    exceptionInfo: ").append(toIndentedString(exceptionInfo)).append("\n");
        sb.append("    checkStatus: ").append(toIndentedString(checkStatus)).append("\n");
        sb.append("    checkRemark: ").append(toIndentedString(checkRemark)).append("\n");
        sb.append("    checkTaskId: ").append(toIndentedString(checkTaskId)).append("\n");
        sb.append("    checkRequestTime: ").append(toIndentedString(checkRequestTime)).append("\n");
        sb.append("    checkResponseTime: ").append(toIndentedString(checkResponseTime)).append("\n");
        sb.append("    checkUserId: ").append(toIndentedString(checkUserId)).append("\n");
        sb.append("    checkUserName: ").append(toIndentedString(checkUserName)).append("\n");
        sb.append("    isHooked: ").append(toIndentedString(isHooked)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("    ticketCreateTime: ").append(toIndentedString(ticketCreateTime)).append("\n");
        sb.append("    imageNum: ").append(toIndentedString(imageNum)).append("\n");
        sb.append("    exceptionNum: ").append(toIndentedString(exceptionNum)).append("\n");
        sb.append("    warningNum: ").append(toIndentedString(warningNum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
