package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * Request
 */
@ApiModel(description = "Request")

@JsonInclude(NON_NULL)
public class GetMethodCodeRequest extends BaseRequest {

    @JsonProperty("type")
    private Integer type = null;

    @JsonIgnore
    public GetMethodCodeRequest type(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * 0-logApi 1-logMq 2-pubSubLog
     *
     * @return type
     **/
    @ApiModelProperty(value = "0-logApi 1-logMq 2-pubSubLog")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetMethodCodeRequest getMethodCodeRequest = (GetMethodCodeRequest) o;
        return Objects.equals(this.type, getMethodCodeRequest.type) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetMethodCodeRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
