package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 修改批次号规则表单数据 Datetime:    2021/6/9   16:29 Author:   cmq
 */
@ApiModel(description = "修改批次号规则数据Request")
@JsonInclude(NON_NULL)
public class UpdateBatchNumberRuleRequest extends BaseRequest {

    @JsonProperty("ruleId")
    private Long ruleId = null;

    @JsonProperty("ruleCode")
    private String ruleCode = null;

    @JsonProperty("ruleName")
    private String ruleName = null;

    @JsonProperty("tenant")
    private String tenant = null;

    @JsonProperty("ruleDefine")
    private String ruleDefine = null;

    @JsonProperty("ruleDesc")
    private String ruleDesc = null;

    @JsonProperty("status")
    private Integer status = null;

    /**
     * 批次号规则主键
     *
     * @return ruleId
     **/
    @ApiModelProperty(value = "批次号规则主键")
    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * 规则编号
     *
     * @return ruleCode
     **/
    @ApiModelProperty(value = "规则编号")
    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    /**
     * 规则名称
     *
     * @return ruleName
     **/
    @ApiModelProperty(value = "规则名称")
    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    /**
     * 所属租户
     *
     * @return tenant
     **/
    @ApiModelProperty(value = "所属租户")
    public String getTenant() {
        return tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    /**
     * 规则定义
     *
     * @return ruleDefine
     **/
    @ApiModelProperty(value = "规则定义")
    public String getRuleDefine() {
        return ruleDefine;
    }

    public void setRuleDefine(String ruleDefine) {
        this.ruleDefine = ruleDefine;
    }

    /**
     * 规则描述
     *
     * @return ruleDesc
     **/
    @ApiModelProperty(value = "规则描述")
    public String getRuleDesc() {
        return ruleDesc;
    }

    public void setRuleDesc(String ruleDesc) {
        this.ruleDesc = ruleDesc;
    }


    /**
     * 启用禁用 1启用 0禁用
     *
     * @return status
     **/
    @ApiModelProperty(value = "启用禁用 1启用 0禁用")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

}
