package com.xforceplus.elephant.image.client.api.compare;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BackBaseBillRequest;
import com.xforceplus.elephant.image.client.model.BackBillDeleteRequest;
import com.xforceplus.elephant.image.client.model.BackCompareBillRequest;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.BaseBillDeleteRequest;
import com.xforceplus.elephant.image.client.model.BatchAuditBillRequest;
import com.xforceplus.elephant.image.client.model.CompareSaveBillH5Request;
import com.xforceplus.elephant.image.client.model.GetBaseBillDetailRequest;
import com.xforceplus.elephant.image.client.model.GetBillTypeListRequest;
import com.xforceplus.elephant.image.client.model.GetCountInfoRequest;
import com.xforceplus.elephant.image.client.model.GetDetailResourceCodeRequest;
import com.xforceplus.elephant.image.client.model.HangBillRequest;
import com.xforceplus.elephant.image.client.model.NoticeBaseBillRequest;
import com.xforceplus.elephant.image.client.model.ReCheckBillRequest;
import com.xforceplus.elephant.image.client.model.ReplaceScanUserRequest;
import com.xforceplus.elephant.image.client.model.SplitBillRequest;
import com.xforceplus.elephant.image.client.model.UpdateVerifyStatusRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "baseBill", description = "the baseBill API", tags = "baseBill")
public interface CompareBaseBillApi {

    @ApiOperation(value = "签收不合格退回", notes = "签收不合格退回", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/back",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse backBaseBill(@ApiParam(value = "request", required = true) @Valid BackBaseBillRequest request
    );


    @ApiOperation(value = "退回单据删除", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/backBillDelete",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse backBillDelete(@ApiParam(value = "request", required = true) @Valid BackBillDeleteRequest request
    );


    @ApiOperation(value = "单据批量提交", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/commit",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse commit(@ApiParam(value = "request", required = true) @Valid BaseBillCommitRequest request
    );


    @ApiOperation(value = "单据批量删除", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/delete",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse delete(@ApiParam(value = "request", required = true) @Valid BaseBillDeleteRequest request
    );

    @ApiOperation(value = "获取退回单据状态操作记录", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/getBackBillOpLog",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBackBillOpLog(@ApiParam(value = "request", required = true) @Valid GetBaseBillDetailRequest request
    );


    @ApiOperation(value = "获取单据详情详情", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/getBaseBillDetail",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBaseBillDetail(@ApiParam(value = "request", required = true) @Valid GetBaseBillDetailRequest request
    );


    @ApiOperation(value = "获取单据号", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/getBillCode/{keyCode}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBillCode(@ApiParam(value = "", required = true) @PathVariable("keyCode") String keyCode
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取单据类型集合", notes = "获取单据类型集合", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/compare/baseBill/getBillTypeList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBillTypeList(@ApiParam(value = "request", required = true) @Valid GetBillTypeListRequest request
    );


    @ApiOperation(value = "获取compare单据数量", notes = "获取compare单据数量", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/countInfo",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getCountInfo(@ApiParam(value = "request", required = true) @Valid GetCountInfoRequest request
    );


    @ApiOperation(value = "获取单据详情资源码", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/getDetailResourceCode",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getDetailResourceCode(@ApiParam(value = "request", required = true) @Valid GetDetailResourceCodeRequest request
    );

    @ApiOperation(value = "groupUser", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/groupUser",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse groupUser(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );

    @ApiOperation(value = "单据挂起", notes = "单据挂起", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/hangBill",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse hangBill(@ApiParam(value = "request", required = true) @Valid HangBillRequest request
    );

    @ApiOperation(value = "获取当前用户所属组织包含的单据字段（组合）", notes = "获取当前用户所属组织包含的单据字段（组合）", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/compare/baseBill/orgExtensions",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse orgExtensions(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "代办退回单据", notes = "代办退回单据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/pendingBack",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse pendingBackBaseBill(@ApiParam(value = "request", required = true) @Valid BackBaseBillRequest request
    );


    @ApiOperation(value = "预付款单据批量删除", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/prePaymentDelete",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse prePaymentDelete(@ApiParam(value = "request", required = true) @Valid BaseBillDeleteRequest request
    );


    @ApiOperation(value = "重算单据", notes = "重算单据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/reCheckBill",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse reCheckBill(@ApiParam(value = "request", required = true) @Valid ReCheckBillRequest request
    );


    @ApiOperation(value = "替换扫描人", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/replaceScanUser",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse replaceScanUser(@ApiParam(value = "request", required = true) @Valid ReplaceScanUserRequest request
    );


    @ApiOperation(value = "拆单", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/split",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse split(@ApiParam(value = "request", required = true) @Valid SplitBillRequest request
    );


    @ApiOperation(value = "更新核验签收状态", notes = "更新核验签收状态", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/updateVerifyStatus",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse updateVerifyStatus(@ApiParam(value = "request", required = true) @Valid UpdateVerifyStatusRequest request
    );


    @ApiOperation(value = "单据稽核", notes = "单据稽核", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/auditBill",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse auditBill(@ApiParam(value = "request", required = true) @Valid BatchAuditBillRequest request
    );

    @ApiOperation(value = "移动端保存稽核单据", notes = "移动端保存稽核单据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/compareSaveBillH5",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse compareSaveBillH5(@ApiParam(value = "request", required = true) @Valid CompareSaveBillH5Request request
    );

    @ApiOperation(value = "获取稽核单据比对详情", notes = "获取稽核单据比对详情", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/getCompareBillAuditDetail",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse getCompareBillAuditDetail(@ApiParam(value = "request", required = true) @Valid GetBaseBillDetailRequest request
    );

    @ApiOperation(value = "稽核单据回退", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/backCompareBill",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse backCompareBill(@ApiParam(value = "request", required = true) @Valid BackCompareBillRequest request
    );

    @ApiOperation(value = "财务收单-收票中通知", notes = "财务收单-收票中通知", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {@ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/compare/baseBill/notice", produces = {"application/json"}, method = RequestMethod.POST)
    CommonResponse noticeBaseBill(@ApiParam(value = "request", required = true) @Valid NoticeBaseBillRequest request
    );

}
