package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 单据退回接口
 */
@ApiModel(description = "单据退回接口")

@JsonInclude(NON_NULL)
public class BackBillDataRequest extends BaseRequest {

    @JsonProperty("billDataId")
    private Long billDataId = null;

    @JsonProperty("backType")
    private Integer backType = null;

    @JsonProperty("backReason")
    private String backReason = null;

    @JsonIgnore
    public BackBillDataRequest billDataId(Long billDataId) {
        this.billDataId = billDataId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return billDataId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getBillDataId() {
        return billDataId;
    }

    public void setBillDataId(Long billDataId) {
        this.billDataId = billDataId;
    }

    @JsonIgnore
    public BackBillDataRequest backType(Integer backType) {
        this.backType = backType;
        return this;
    }

    /**
     * 退回类型
     *
     * @return backType
     **/
    @ApiModelProperty(value = "退回类型")
    public Integer getBackType() {
        return backType;
    }

    public void setBackType(Integer backType) {
        this.backType = backType;
    }

    @JsonIgnore
    public BackBillDataRequest backReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    /**
     * 退回原因
     *
     * @return backReason
     **/
    @ApiModelProperty(value = "退回原因")
    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BackBillDataRequest backBillDataRequest = (BackBillDataRequest) o;
        return Objects.equals(this.billDataId, backBillDataRequest.billDataId) &&
            Objects.equals(this.backType, backBillDataRequest.backType) &&
            Objects.equals(this.backReason, backBillDataRequest.backReason) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billDataId, backType, backReason, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BackBillDataRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billDataId: ").append(toIndentedString(billDataId)).append("\n");
        sb.append("    backType: ").append(toIndentedString(backType)).append("\n");
        sb.append("    backReason: ").append(toIndentedString(backReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
