package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 更新识别规则状态Request
 */
@ApiModel(description = "更新识别规则状态Request")

@JsonInclude(NON_NULL)
public class EnableDataMappingRequest extends BaseRequest {

    @JsonProperty("ids")
    private List<Long> ids = new ArrayList<Long>();

    @JsonProperty("ableStatus")
    private Integer ableStatus = null;

    @JsonIgnore
    public EnableDataMappingRequest ids(List<Long> ids) {
        this.ids = ids;
        return this;
    }

    public EnableDataMappingRequest addIdsItem(Long idsItem) {
        this.ids.add(idsItem);
        return this;
    }

    /**
     * 规则id聊表
     *
     * @return ids
     **/
    @ApiModelProperty(value = "规则id聊表")
    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    @JsonIgnore
    public EnableDataMappingRequest ableStatus(Integer ableStatus) {
        this.ableStatus = ableStatus;
        return this;
    }

    /**
     * 启用/禁用
     *
     * @return ableStatus
     **/
    @ApiModelProperty(value = "启用/禁用")
    public Integer getAbleStatus() {
        return ableStatus;
    }

    public void setAbleStatus(Integer ableStatus) {
        this.ableStatus = ableStatus;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnableDataMappingRequest enableDataMappingRequest = (EnableDataMappingRequest) o;
        return Objects.equals(this.ids, enableDataMappingRequest.ids) &&
            Objects.equals(this.ableStatus, enableDataMappingRequest.ableStatus) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ids, ableStatus, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnableDataMappingRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
        sb.append("    ableStatus: ").append(toIndentedString(ableStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
