package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * 单据数据Request
 */
@ApiModel(description = "单据数据Request")

@JsonInclude(NON_NULL)
public class GetBillDataListRequest extends PageRequest {

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("billTypeCode")
    private String billTypeCode = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("billAmount")
    private BigDecimal billAmount = null;

    @JsonProperty("billCreateUser")
    private String billCreateUser = null;

    @JsonProperty("billCreateTime")
    private Long billCreateTime = null;

    @JsonProperty("scanUserId")
    private Long scanUserId = null;

    @JsonProperty("scanUserName")
    private String scanUserName = null;

    @JsonProperty("packageCode")
    private String packageCode = null;

    @JsonProperty("logisticsStatus")
    private Integer logisticsStatus = null;

    @JsonProperty("logisticsTime")
    private Long logisticsTime = null;

    @JsonProperty("signStatus")
    private Integer signStatus = null;

    @JsonProperty("signTime")
    private Long signTime = null;

    @JsonProperty("isPublic")
    private String isPublic = null;

    @JsonProperty("isSecret")
    private Integer isSecret = null;

    @JsonProperty("hangType")
    private Integer hangType = null;

    @JsonProperty("hangReason")
    private String hangReason = null;

    @JsonProperty("hangTime")
    private Long hangTime = null;

    @JsonProperty("backType")
    private Integer backType = null;

    @JsonProperty("backReason")
    private String backReason = null;

    @JsonProperty("billDataStatus")
    private Integer billDataStatus = null;

    @JsonProperty("billDataTime")
    private Long billDataTime = null;

    @JsonProperty("verifyStatus")
    private Integer verifyStatus = null;

    @JsonProperty("verifyTime")
    private Long verifyTime = null;

    @JsonProperty("ticketCount")
    private Integer ticketCount = null;

    @JsonProperty("imageCount")
    private Integer imageCount = null;

    @JsonProperty("exceptionCount")
    private Integer exceptionCount = null;

    @JsonProperty("warningCount")
    private Integer warningCount = null;

    @JsonProperty("isException")
    private Integer isException = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("leftXPoint")
    private Integer leftXPoint = null;

    @JsonProperty("leftYPoint")
    private Integer leftYPoint = null;

    @JsonProperty("rightXPoint")
    private Integer rightXPoint = null;

    @JsonProperty("rightYPoint")
    private Integer rightYPoint = null;

    @JsonProperty("orientation")
    private Integer orientation = null;

    @JsonIgnore
    public GetBillDataListRequest id(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 自增主键
     *
     * @return id
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public GetBillDataListRequest tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public GetBillDataListRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public GetBillDataListRequest batchNo(String batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    /**
     * 批次号
     *
     * @return batchNo
     **/
    @ApiModelProperty(value = "批次号")
    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public GetBillDataListRequest billTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
        return this;
    }

    /**
     * 单据类型code
     *
     * @return billTypeCode
     **/
    @ApiModelProperty(value = "单据类型code")
    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    @JsonIgnore
    public GetBillDataListRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public GetBillDataListRequest billAmount(BigDecimal billAmount) {
        this.billAmount = billAmount;
        return this;
    }

    /**
     * 单据金额
     *
     * @return billAmount
     **/
    @ApiModelProperty(value = "单据金额")
    public BigDecimal getBillAmount() {
        return billAmount;
    }

    public void setBillAmount(BigDecimal billAmount) {
        this.billAmount = billAmount;
    }

    @JsonIgnore
    public GetBillDataListRequest billCreateUser(String billCreateUser) {
        this.billCreateUser = billCreateUser;
        return this;
    }

    /**
     * 提单人
     *
     * @return billCreateUser
     **/
    @ApiModelProperty(value = "提单人")
    public String getBillCreateUser() {
        return billCreateUser;
    }

    public void setBillCreateUser(String billCreateUser) {
        this.billCreateUser = billCreateUser;
    }

    @JsonIgnore
    public GetBillDataListRequest billCreateTime(Long billCreateTime) {
        this.billCreateTime = billCreateTime;
        return this;
    }

    /**
     * 提单时间
     *
     * @return billCreateTime
     **/
    @ApiModelProperty(value = "提单时间")
    public Long getBillCreateTime() {
        return billCreateTime;
    }

    public void setBillCreateTime(Long billCreateTime) {
        this.billCreateTime = billCreateTime;
    }

    @JsonIgnore
    public GetBillDataListRequest scanUserId(Long scanUserId) {
        this.scanUserId = scanUserId;
        return this;
    }

    /**
     * 扫描人ID
     *
     * @return scanUserId
     **/
    @ApiModelProperty(value = "扫描人ID")
    public Long getScanUserId() {
        return scanUserId;
    }

    public void setScanUserId(Long scanUserId) {
        this.scanUserId = scanUserId;
    }

    @JsonIgnore
    public GetBillDataListRequest scanUserName(String scanUserName) {
        this.scanUserName = scanUserName;
        return this;
    }

    /**
     * 扫描人姓名
     *
     * @return scanUserName
     **/
    @ApiModelProperty(value = "扫描人姓名")
    public String getScanUserName() {
        return scanUserName;
    }

    public void setScanUserName(String scanUserName) {
        this.scanUserName = scanUserName;
    }

    @JsonIgnore
    public GetBillDataListRequest packageCode(String packageCode) {
        this.packageCode = packageCode;
        return this;
    }

    /**
     * 运单号
     *
     * @return packageCode
     **/
    @ApiModelProperty(value = "运单号")
    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    @JsonIgnore
    public GetBillDataListRequest logisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
        return this;
    }

    /**
     * 物流状态：0-待寄送，1-已寄送
     *
     * @return logisticsStatus
     **/
    @ApiModelProperty(value = "物流状态：0-待寄送，1-已寄送")
    public Integer getLogisticsStatus() {
        return logisticsStatus;
    }

    public void setLogisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    @JsonIgnore
    public GetBillDataListRequest logisticsTime(Long logisticsTime) {
        this.logisticsTime = logisticsTime;
        return this;
    }

    /**
     * 寄送时间
     *
     * @return logisticsTime
     **/
    @ApiModelProperty(value = "寄送时间")
    public Long getLogisticsTime() {
        return logisticsTime;
    }

    public void setLogisticsTime(Long logisticsTime) {
        this.logisticsTime = logisticsTime;
    }

    @JsonIgnore
    public GetBillDataListRequest signStatus(Integer signStatus) {
        this.signStatus = signStatus;
        return this;
    }

    /**
     * 签收状态：0-未签收，1-签收成功，2-签收失败
     *
     * @return signStatus
     **/
    @ApiModelProperty(value = "签收状态：0-未签收，1-签收成功，2-签收失败")
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    @JsonIgnore
    public GetBillDataListRequest signTime(Long signTime) {
        this.signTime = signTime;
        return this;
    }

    /**
     * 签收时间
     *
     * @return signTime
     **/
    @ApiModelProperty(value = "签收时间")
    public Long getSignTime() {
        return signTime;
    }

    public void setSignTime(Long signTime) {
        this.signTime = signTime;
    }

    @JsonIgnore
    public GetBillDataListRequest isPublic(String isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    /**
     * 是否公共：0-否，1-是
     *
     * @return isPublic
     **/
    @ApiModelProperty(value = "是否公共：0-否，1-是")
    public String getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(String isPublic) {
        this.isPublic = isPublic;
    }

    @JsonIgnore
    public GetBillDataListRequest isSecret(Integer isSecret) {
        this.isSecret = isSecret;
        return this;
    }

    /**
     * 是否敏感：0-否，1-是
     *
     * @return isSecret
     **/
    @ApiModelProperty(value = "是否敏感：0-否，1-是")
    public Integer getIsSecret() {
        return isSecret;
    }

    public void setIsSecret(Integer isSecret) {
        this.isSecret = isSecret;
    }

    @JsonIgnore
    public GetBillDataListRequest hangType(Integer hangType) {
        this.hangType = hangType;
        return this;
    }

    /**
     * 挂起原因类型
     *
     * @return hangType
     **/
    @ApiModelProperty(value = "挂起原因类型")
    public Integer getHangType() {
        return hangType;
    }

    public void setHangType(Integer hangType) {
        this.hangType = hangType;
    }

    @JsonIgnore
    public GetBillDataListRequest hangReason(String hangReason) {
        this.hangReason = hangReason;
        return this;
    }

    /**
     * 挂起原因备注
     *
     * @return hangReason
     **/
    @ApiModelProperty(value = "挂起原因备注")
    public String getHangReason() {
        return hangReason;
    }

    public void setHangReason(String hangReason) {
        this.hangReason = hangReason;
    }

    @JsonIgnore
    public GetBillDataListRequest hangTime(Long hangTime) {
        this.hangTime = hangTime;
        return this;
    }

    /**
     * 挂起时间
     *
     * @return hangTime
     **/
    @ApiModelProperty(value = "挂起时间")
    public Long getHangTime() {
        return hangTime;
    }

    public void setHangTime(Long hangTime) {
        this.hangTime = hangTime;
    }

    @JsonIgnore
    public GetBillDataListRequest backType(Integer backType) {
        this.backType = backType;
        return this;
    }

    /**
     * 退回类型：1-审批驳回，2-核验退回
     *
     * @return backType
     **/
    @ApiModelProperty(value = "退回类型：1-审批驳回，2-核验退回")
    public Integer getBackType() {
        return backType;
    }

    public void setBackType(Integer backType) {
        this.backType = backType;
    }

    @JsonIgnore
    public GetBillDataListRequest backReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    /**
     * 退回原因
     *
     * @return backReason
     **/
    @ApiModelProperty(value = "退回原因")
    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    @JsonIgnore
    public GetBillDataListRequest billDataStatus(Integer billDataStatus) {
        this.billDataStatus = billDataStatus;
        return this;
    }

    /**
     * 单据状态：0-待提交，1-已提交，2-暂挂起，3-已锁定，4-已退回，5-已作废
     *
     * @return billDataStatus
     **/
    @ApiModelProperty(value = "单据状态：0-待提交，1-已提交，2-暂挂起，3-已锁定，4-已退回，5-已作废")
    public Integer getBillDataStatus() {
        return billDataStatus;
    }

    public void setBillDataStatus(Integer billDataStatus) {
        this.billDataStatus = billDataStatus;
    }

    @JsonIgnore
    public GetBillDataListRequest billDataTime(Long billDataTime) {
        this.billDataTime = billDataTime;
        return this;
    }

    /**
     * 状态变更时间
     *
     * @return billDataTime
     **/
    @ApiModelProperty(value = "状态变更时间")
    public Long getBillDataTime() {
        return billDataTime;
    }

    public void setBillDataTime(Long billDataTime) {
        this.billDataTime = billDataTime;
    }

    @JsonIgnore
    public GetBillDataListRequest verifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
        return this;
    }

    /**
     * 核验签收状态：0-待核验，1-核验合格，2-暂挂起，3-核验不合格
     *
     * @return verifyStatus
     **/
    @ApiModelProperty(value = "核验签收状态：0-待核验，1-核验合格，2-暂挂起，3-核验不合格")
    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    @JsonIgnore
    public GetBillDataListRequest verifyTime(Long verifyTime) {
        this.verifyTime = verifyTime;
        return this;
    }

    /**
     * 核验签收
     *
     * @return verifyTime
     **/
    @ApiModelProperty(value = "核验签收")
    public Long getVerifyTime() {
        return verifyTime;
    }

    public void setVerifyTime(Long verifyTime) {
        this.verifyTime = verifyTime;
    }

    @JsonIgnore
    public GetBillDataListRequest ticketCount(Integer ticketCount) {
        this.ticketCount = ticketCount;
        return this;
    }

    /**
     * 单据下的单证影像数量
     *
     * @return ticketCount
     **/
    @ApiModelProperty(value = "单据下的单证影像数量")
    public Integer getTicketCount() {
        return ticketCount;
    }

    public void setTicketCount(Integer ticketCount) {
        this.ticketCount = ticketCount;
    }

    @JsonIgnore
    public GetBillDataListRequest imageCount(Integer imageCount) {
        this.imageCount = imageCount;
        return this;
    }

    /**
     * 已有影像张数
     *
     * @return imageCount
     **/
    @ApiModelProperty(value = "已有影像张数")
    public Integer getImageCount() {
        return imageCount;
    }

    public void setImageCount(Integer imageCount) {
        this.imageCount = imageCount;
    }

    @JsonIgnore
    public GetBillDataListRequest exceptionCount(Integer exceptionCount) {
        this.exceptionCount = exceptionCount;
        return this;
    }

    /**
     * 异常数
     *
     * @return exceptionCount
     **/
    @ApiModelProperty(value = "异常数")
    public Integer getExceptionCount() {
        return exceptionCount;
    }

    public void setExceptionCount(Integer exceptionCount) {
        this.exceptionCount = exceptionCount;
    }

    @JsonIgnore
    public GetBillDataListRequest warningCount(Integer warningCount) {
        this.warningCount = warningCount;
        return this;
    }

    /**
     * 预警数
     *
     * @return warningCount
     **/
    @ApiModelProperty(value = "预警数")
    public Integer getWarningCount() {
        return warningCount;
    }

    public void setWarningCount(Integer warningCount) {
        this.warningCount = warningCount;
    }

    @JsonIgnore
    public GetBillDataListRequest isException(Integer isException) {
        this.isException = isException;
        return this;
    }

    /**
     * 单据是否异常 0-否 1-是
     *
     * @return isException
     **/
    @ApiModelProperty(value = "单据是否异常 0-否 1-是")
    public Integer getIsException() {
        return isException;
    }

    public void setIsException(Integer isException) {
        this.isException = isException;
    }

    @JsonIgnore
    public GetBillDataListRequest exceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    /**
     * 单据异常信息
     *
     * @return exceptionInfo
     **/
    @ApiModelProperty(value = "单据异常信息")
    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    @JsonIgnore
    public GetBillDataListRequest createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public GetBillDataListRequest createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUser() {
        return createUserId;
    }

    public void setCreateUser(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public GetBillDataListRequest createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public GetBillDataListRequest updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public GetBillDataListRequest updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public GetBillDataListRequest updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @JsonIgnore
    public GetBillDataListRequest leftXPoint(Integer leftXPoint) {
        this.leftXPoint = leftXPoint;
        return this;
    }

    /**
     * 左上角顶点x坐标
     *
     * @return leftXPoint
     **/
    @ApiModelProperty(value = "左上角顶点x坐标")
    public Integer getLeftXPoint() {
        return leftXPoint;
    }

    public void setLeftXPoint(Integer leftXPoint) {
        this.leftXPoint = leftXPoint;
    }

    @JsonIgnore
    public GetBillDataListRequest leftYPoint(Integer leftYPoint) {
        this.leftYPoint = leftYPoint;
        return this;
    }

    /**
     * 左上角顶点y坐标
     *
     * @return leftYPoint
     **/
    @ApiModelProperty(value = "左上角顶点y坐标")
    public Integer getLeftYPoint() {
        return leftYPoint;
    }

    public void setLeftYPoint(Integer leftYPoint) {
        this.leftYPoint = leftYPoint;
    }

    @JsonIgnore
    public GetBillDataListRequest rightXPoint(Integer rightXPoint) {
        this.rightXPoint = rightXPoint;
        return this;
    }

    /**
     * 右下角顶点x坐标
     *
     * @return rightXPoint
     **/
    @ApiModelProperty(value = "右下角顶点x坐标")
    public Integer getRightXPoint() {
        return rightXPoint;
    }

    public void setRightXPoint(Integer rightXPoint) {
        this.rightXPoint = rightXPoint;
    }

    @JsonIgnore
    public GetBillDataListRequest rightYPoint(Integer rightYPoint) {
        this.rightYPoint = rightYPoint;
        return this;
    }

    /**
     * 右下角顶点y坐标
     *
     * @return rightYPoint
     **/
    @ApiModelProperty(value = "右下角顶点y坐标")
    public Integer getRightYPoint() {
        return rightYPoint;
    }

    public void setRightYPoint(Integer rightYPoint) {
        this.rightYPoint = rightYPoint;
    }

    @JsonIgnore
    public GetBillDataListRequest orientation(Integer orientation) {
        this.orientation = orientation;
        return this;
    }

    /**
     * 方向
     *
     * @return orientation
     **/
    @ApiModelProperty(value = "方向")
    public Integer getOrientation() {
        return orientation;
    }

    public void setOrientation(Integer orientation) {
        this.orientation = orientation;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetBillDataListRequest getBillDataListRequest = (GetBillDataListRequest) o;
        return Objects.equals(this.id, getBillDataListRequest.id) &&
            Objects.equals(this.tenantId, getBillDataListRequest.tenantId) &&
            Objects.equals(this.imageId, getBillDataListRequest.imageId) &&
            Objects.equals(this.batchNo, getBillDataListRequest.batchNo) &&
            Objects.equals(this.billTypeCode, getBillDataListRequest.billTypeCode) &&
            Objects.equals(this.billCode, getBillDataListRequest.billCode) &&
            Objects.equals(this.billAmount, getBillDataListRequest.billAmount) &&
            Objects.equals(this.billCreateUser, getBillDataListRequest.billCreateUser) &&
            Objects.equals(this.billCreateTime, getBillDataListRequest.billCreateTime) &&
            Objects.equals(this.scanUserId, getBillDataListRequest.scanUserId) &&
            Objects.equals(this.scanUserName, getBillDataListRequest.scanUserName) &&
            Objects.equals(this.packageCode, getBillDataListRequest.packageCode) &&
            Objects.equals(this.logisticsStatus, getBillDataListRequest.logisticsStatus) &&
            Objects.equals(this.logisticsTime, getBillDataListRequest.logisticsTime) &&
            Objects.equals(this.signStatus, getBillDataListRequest.signStatus) &&
            Objects.equals(this.signTime, getBillDataListRequest.signTime) &&
            Objects.equals(this.isPublic, getBillDataListRequest.isPublic) &&
            Objects.equals(this.isSecret, getBillDataListRequest.isSecret) &&
            Objects.equals(this.hangType, getBillDataListRequest.hangType) &&
            Objects.equals(this.hangReason, getBillDataListRequest.hangReason) &&
            Objects.equals(this.hangTime, getBillDataListRequest.hangTime) &&
            Objects.equals(this.backType, getBillDataListRequest.backType) &&
            Objects.equals(this.backReason, getBillDataListRequest.backReason) &&
            Objects.equals(this.billDataStatus, getBillDataListRequest.billDataStatus) &&
            Objects.equals(this.billDataTime, getBillDataListRequest.billDataTime) &&
            Objects.equals(this.verifyStatus, getBillDataListRequest.verifyStatus) &&
            Objects.equals(this.verifyTime, getBillDataListRequest.verifyTime) &&
            Objects.equals(this.ticketCount, getBillDataListRequest.ticketCount) &&
            Objects.equals(this.imageCount, getBillDataListRequest.imageCount) &&
            Objects.equals(this.exceptionCount, getBillDataListRequest.exceptionCount) &&
            Objects.equals(this.warningCount, getBillDataListRequest.warningCount) &&
            Objects.equals(this.isException, getBillDataListRequest.isException) &&
            Objects.equals(this.exceptionInfo, getBillDataListRequest.exceptionInfo) &&
            Objects.equals(this.createTime, getBillDataListRequest.createTime) &&
            Objects.equals(this.createUserId, getBillDataListRequest.createUserId) &&
            Objects.equals(this.createUserName, getBillDataListRequest.createUserName) &&
            Objects.equals(this.updateTime, getBillDataListRequest.updateTime) &&
            Objects.equals(this.updateUserId, getBillDataListRequest.updateUserId) &&
            Objects.equals(this.updateUserName, getBillDataListRequest.updateUserName) &&
            Objects.equals(this.leftXPoint, getBillDataListRequest.leftXPoint) &&
            Objects.equals(this.leftYPoint, getBillDataListRequest.leftYPoint) &&
            Objects.equals(this.rightXPoint, getBillDataListRequest.rightXPoint) &&
            Objects.equals(this.rightYPoint, getBillDataListRequest.rightYPoint) &&
            Objects.equals(this.orientation, getBillDataListRequest.orientation) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(id, tenantId, imageId, batchNo, billTypeCode, billCode, billAmount, billCreateUser, billCreateTime, scanUserId, scanUserName, packageCode, logisticsStatus, logisticsTime, signStatus,
                signTime, isPublic, isSecret, hangType, hangReason, hangTime, backType, backReason, billDataStatus, billDataTime, verifyStatus, verifyTime, ticketCount, imageCount, exceptionCount,
                warningCount, isException, exceptionInfo, createTime, createUserId, createUserName, updateTime, updateUserId, updateUserName, leftXPoint, leftYPoint, rightXPoint, rightYPoint,
                orientation, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetBillDataListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
        sb.append("    billTypeCode: ").append(toIndentedString(billTypeCode)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    billAmount: ").append(toIndentedString(billAmount)).append("\n");
        sb.append("    billCreateUser: ").append(toIndentedString(billCreateUser)).append("\n");
        sb.append("    billCreateTime: ").append(toIndentedString(billCreateTime)).append("\n");
        sb.append("    scanUserId: ").append(toIndentedString(scanUserId)).append("\n");
        sb.append("    scanUserName: ").append(toIndentedString(scanUserName)).append("\n");
        sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
        sb.append("    logisticsStatus: ").append(toIndentedString(logisticsStatus)).append("\n");
        sb.append("    logisticsTime: ").append(toIndentedString(logisticsTime)).append("\n");
        sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
        sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
        sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
        sb.append("    isSecret: ").append(toIndentedString(isSecret)).append("\n");
        sb.append("    hangType: ").append(toIndentedString(hangType)).append("\n");
        sb.append("    hangReason: ").append(toIndentedString(hangReason)).append("\n");
        sb.append("    hangTime: ").append(toIndentedString(hangTime)).append("\n");
        sb.append("    backType: ").append(toIndentedString(backType)).append("\n");
        sb.append("    backReason: ").append(toIndentedString(backReason)).append("\n");
        sb.append("    billDataStatus: ").append(toIndentedString(billDataStatus)).append("\n");
        sb.append("    billDataTime: ").append(toIndentedString(billDataTime)).append("\n");
        sb.append("    verifyStatus: ").append(toIndentedString(verifyStatus)).append("\n");
        sb.append("    verifyTime: ").append(toIndentedString(verifyTime)).append("\n");
        sb.append("    ticketCount: ").append(toIndentedString(ticketCount)).append("\n");
        sb.append("    imageCount: ").append(toIndentedString(imageCount)).append("\n");
        sb.append("    exceptionCount: ").append(toIndentedString(exceptionCount)).append("\n");
        sb.append("    warningCount: ").append(toIndentedString(warningCount)).append("\n");
        sb.append("    isException: ").append(toIndentedString(isException)).append("\n");
        sb.append("    exceptionInfo: ").append(toIndentedString(exceptionInfo)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("    leftXPoint: ").append(toIndentedString(leftXPoint)).append("\n");
        sb.append("    leftYPoint: ").append(toIndentedString(leftYPoint)).append("\n");
        sb.append("    rightXPoint: ").append(toIndentedString(rightXPoint)).append("\n");
        sb.append("    rightYPoint: ").append(toIndentedString(rightYPoint)).append("\n");
        sb.append("    orientation: ").append(toIndentedString(orientation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
