package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 拆单request
 */
@ApiModel(description = "拆单request")

@JsonInclude(NON_NULL)
public class SplitBillRequest extends BaseRequest {

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("billTypeCode")
    private String billTypeCode = null;

    @JsonProperty("billAmountWithTax")
    private String billAmountWithTax = null;

    @JsonProperty("billCreateUser")
    private String billCreateUser = null;

    @JsonProperty("billCreateTime")
    private Long billCreateTime = null;

    @JsonIgnore
    public SplitBillRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 拆单影像id
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "拆单影像id")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public SplitBillRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public SplitBillRequest billTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
        return this;
    }

    /**
     * 单据类型
     *
     * @return billTypeCode
     **/
    @ApiModelProperty(value = "单据类型")
    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    @JsonIgnore
    public SplitBillRequest billAmountWithTax(String billAmountWithTax) {
        this.billAmountWithTax = billAmountWithTax;
        return this;
    }

    /**
     * 金额
     *
     * @return billAmountWithTax
     **/
    @ApiModelProperty(value = "金额")
    public String getBillAmountWithTax() {
        return billAmountWithTax;
    }

    public void setBillAmountWithTax(String billAmountWithTax) {
        this.billAmountWithTax = billAmountWithTax;
    }

    @JsonIgnore
    public SplitBillRequest billCreateUser(String billCreateUser) {
        this.billCreateUser = billCreateUser;
        return this;
    }

    /**
     * 提单人姓名
     *
     * @return billCreateUser
     **/
    @ApiModelProperty(value = "提单人姓名")
    public String getBillCreateUser() {
        return billCreateUser;
    }

    public void setBillCreateUser(String billCreateUser) {
        this.billCreateUser = billCreateUser;
    }

    @JsonIgnore
    public SplitBillRequest billCreateTime(Long billCreateTime) {
        this.billCreateTime = billCreateTime;
        return this;
    }

    /**
     * 提单时间
     *
     * @return billCreateTime
     **/
    @ApiModelProperty(value = "提单时间")
    public Long getBillCreateTime() {
        return billCreateTime;
    }

    public void setBillCreateTime(Long billCreateTime) {
        this.billCreateTime = billCreateTime;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SplitBillRequest splitBillRequest = (SplitBillRequest) o;
        return Objects.equals(this.imageId, splitBillRequest.imageId) &&
            Objects.equals(this.billCode, splitBillRequest.billCode) &&
            Objects.equals(this.billTypeCode, splitBillRequest.billTypeCode) &&
            Objects.equals(this.billAmountWithTax, splitBillRequest.billAmountWithTax) &&
            Objects.equals(this.billCreateUser, splitBillRequest.billCreateUser) &&
            Objects.equals(this.billCreateTime, splitBillRequest.billCreateTime) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageId, billCode, billTypeCode, billAmountWithTax, billCreateUser, billCreateTime, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitBillRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    billTypeCode: ").append(toIndentedString(billTypeCode)).append("\n");
        sb.append("    billAmountWithTax: ").append(toIndentedString(billAmountWithTax)).append("\n");
        sb.append("    billCreateUser: ").append(toIndentedString(billCreateUser)).append("\n");
        sb.append("    billCreateTime: ").append(toIndentedString(billCreateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
