package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 影像表Request
 */
@ApiModel(description = "影像表Request")

@JsonInclude(NON_NULL)
public class UpdateImageRequest extends BaseRequest {

    @JsonProperty("entities")
    private List<ImageDTO> entities = new ArrayList<ImageDTO>();

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("ocrBillCode")
    private String ocrBillCode = null;

    @JsonIgnore
    public UpdateImageRequest entities(List<ImageDTO> entities) {
        this.entities = entities;
        return this;
    }

    public UpdateImageRequest addEntitiesItem(ImageDTO entitiesItem) {
        this.entities.add(entitiesItem);
        return this;
    }

    /**
     * Get entities
     *
     * @return entities
     **/
    @ApiModelProperty(value = "")
    public List<ImageDTO> getEntities() {
        return entities;
    }

    public void setEntities(List<ImageDTO> entities) {
        this.entities = entities;
    }

    @JsonIgnore
    public UpdateImageRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public UpdateImageRequest ocrBillCode(String ocrBillCode) {
        this.ocrBillCode = ocrBillCode;
        return this;
    }

    /**
     * ocr单据号
     *
     * @return ocrBillCode
     **/
    @ApiModelProperty(value = "ocr单据号")
    public String getOcrBillCode() {
        return ocrBillCode;
    }

    public void setOcrBillCode(String ocrBillCode) {
        this.ocrBillCode = ocrBillCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateImageRequest updateImageRequest = (UpdateImageRequest) o;
        return Objects.equals(this.entities, updateImageRequest.entities) &&
            Objects.equals(this.billCode, updateImageRequest.billCode) &&
            Objects.equals(this.ocrBillCode, updateImageRequest.ocrBillCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entities, billCode, ocrBillCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    ocrBillCode: ").append(toIndentedString(ocrBillCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
