package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

/**
 * 影像上传Request
 */
@ApiModel(description = "影像上传Request")

@JsonInclude(NON_NULL)
public class UploadRequest extends BaseRequest {

    @JsonProperty("uploadImageDTOList")
    List<UploadImageDTO> uploadImageDTOList = null;

    @JsonProperty("systemOrig")
    private String systemOrig = null;

    @JsonProperty("serialNumber")
    private String serialNumber = null;

    @JsonProperty("billEntityCode")
    private String billEntityCode = null;

    @JsonProperty("isPublic")
    private String isPublic = null;

    @JsonProperty("ext")
    private JSONObject ext = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("parentImageId")
    private Long parentImageId = null;

    @JsonProperty("orgId")
    private Long orgId = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    @JsonProperty("orgName")
    private String orgName = null;

    @JsonProperty("requireOcrFlag")
    private String requireOcrFlag = null;


    public List<UploadImageDTO> getUploadImageDTOList() {
        return uploadImageDTOList;
    }

    public void setUploadImageDTOList(List<UploadImageDTO> uploadImageDTOList) {
        this.uploadImageDTOList = uploadImageDTOList;
    }

    @JsonIgnore
    public UploadRequest systemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
        return this;
    }

    /**
     * 系统来源  1-扫描 2-上传 3-接口 4票税助手 99其他  5-移动端上传  6-移动端卡包
     *
     * @return systemOrig
     **/
    @ApiModelProperty(value = "系统来源  1-扫描 2-上传 3-接口 4票税助手 99其他  5-移动端上传  6-移动端卡包")
    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }


    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getBillEntityCode() {
        return billEntityCode;
    }

    public void setBillEntityCode(String billEntityCode) {
        this.billEntityCode = billEntityCode;
    }

    public String getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(String isPublic) {
        this.isPublic = isPublic;
    }

    public JSONObject getExt() {
        return ext;
    }

    public void setExt(JSONObject ext) {
        this.ext = ext;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getParentImageId() {
        return parentImageId;
    }

    public void setParentImageId(Long parentImageId) {
        this.parentImageId = parentImageId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getRequireOcrFlag() {
        return requireOcrFlag;
    }

    public void setRequireOcrFlag(String requireOcrFlag) {
        this.requireOcrFlag = requireOcrFlag;
    }

}
