package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetLabelListRequest;
import com.xforceplus.elephant.image.client.model.SaveLabelRequest;
import com.xforceplus.elephant.image.client.model.UpdateLabelStatusRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "label", description = "the label API", tags = "label")
public interface LabelApi {

    @ApiOperation(value = "获取标签列表", notes = "获取标签列表", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/label/getLabelList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLabelList(@ApiParam(value = "request", required = true) @Valid GetLabelListRequest request
    );


    @ApiOperation(value = "新增标签", notes = "新增标签", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/label/saveLabel",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveLabel(@ApiParam(value = "request", required = true) @Valid SaveLabelRequest request
    );


    @ApiOperation(value = "修改标签启用停用删除", notes = "修改标签启用停用删除", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/label/updateLabelStatus",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse updateLabelStatus(@ApiParam(value = "request", required = true) @Valid UpdateLabelStatusRequest request
    );

}
