package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ShareImageRequest;
import com.xforceplus.elephant.image.client.model.UsedAmountRequest;
import com.xforceplus.elephant.image.client.model.UsedAmountResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/11/6 15:51
 */
@Api(value = "一票多用", description = "一票多用", tags = "一票多用")
public interface MultipurposeApi {


    @ApiOperation(value = "一票多用分享发票", notes = "一票多用分享发票")
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "一票多用分享发票结果")})
    @RequestMapping(value = "/multipurpose/image/share",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse shareImage(@ApiParam(value = "request", required = true) @Valid ShareImageRequest request
    );

    @ApiOperation(value = "一票多用编辑提报金额", notes = "一票多用编辑提报金额")
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "一票多用辑提报金额")})
    @RequestMapping(value = "/multipurpose/ticket/used-amount",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse<UsedAmountResponse> editUsedAmount(@ApiParam(value = "request", required = true) @Valid UsedAmountRequest request
    );

}
