package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 统计识别Request
 */
@ApiModel(description = "统计识别Request")

@JsonInclude(NON_NULL)
public class CountRecStatusRequest extends BaseRequest {

    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    @JsonIgnore
    public CountRecStatusRequest billCodes(List<String> billCodes) {
        this.billCodes = billCodes;
        return this;
    }

    public CountRecStatusRequest addBillCodesItem(String billCodesItem) {
        this.billCodes.add(billCodesItem);
        return this;
    }

    /**
     * 单据codes
     *
     * @return billCodes
     **/
    @ApiModelProperty(value = "单据codes")
    public List<String> getBillCodes() {
        return billCodes;
    }

    public void setBillCodes(List<String> billCodes) {
        this.billCodes = billCodes;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CountRecStatusRequest countRecStatusRequest = (CountRecStatusRequest) o;
        return Objects.equals(this.billCodes, countRecStatusRequest.billCodes) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCodes, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CountRecStatusRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCodes: ").append(toIndentedString(billCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
