package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 获取count请求
 */
@ApiModel(description = "获取count请求")

@JsonInclude(NON_NULL)
public class GetCountInfoRequest extends BaseRequest {

    @JsonProperty("entityCode")
    private String entityCode = null;

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonIgnore
    public GetCountInfoRequest entityCode(String entityCode) {
        this.entityCode = entityCode;
        return this;
    }

    /**
     * entityCode
     *
     * @return entityCode
     **/
    @ApiModelProperty(value = "entityCode")
    public String getEntityCode() {
        return entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    @JsonIgnore
    public GetCountInfoRequest pageCode(String pageCode) {
        this.pageCode = pageCode;
        return this;
    }

    /**
     * pageCode
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "pageCode")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetCountInfoRequest getCountInfoRequest = (GetCountInfoRequest) o;
        return Objects.equals(this.entityCode, getCountInfoRequest.entityCode) &&
            Objects.equals(this.pageCode, getCountInfoRequest.pageCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entityCode, pageCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetCountInfoRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    entityCode: ").append(toIndentedString(entityCode)).append("\n");
        sb.append("    pageCode: ").append(toIndentedString(pageCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
