package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 获取流水号request Datetime:    2021/6/10   16:32 Author:   cmq
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "获取流水号数据Request")
@JsonInclude(NON_NULL)
public class GetSerialNumberRequest extends BaseRequest {

    @JsonProperty("ruleCode")
    private String ruleCode = null;

    @JsonProperty("date")
    private String date = null;

    /**
     * 枚举值 多个以;分割
     */
    @JsonProperty("enumeration")
    private String enumeration = null;

    @JsonProperty("length")
    private Integer length = null;

    @JsonProperty("autoIncrementAble")
    private Integer autoIncrementAble = null;

}
