package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 处理退回单据接口
 */
@ApiModel(description = "处理退回单据接口")

@JsonInclude(NON_NULL)
public class HandleBackBillRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("handleType")
    private Integer handleType = null;

    @JsonProperty("backReason")
    private String backReason = null;

    @JsonProperty("waybillNo")
    private String waybillNo = null;

    @JsonProperty("expressName")
    private String expressName = null;

    @JsonProperty("backTime")
    private Long backTime = null;

    @JsonIgnore
    public HandleBackBillRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public HandleBackBillRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public HandleBackBillRequest handleType(Integer handleType) {
        this.handleType = handleType;
        return this;
    }

    /**
     * 处理类型：0-无需退回，1-邮寄，2-自取
     *
     * @return handleType
     **/
    @ApiModelProperty(value = "处理类型：0-无需退回，1-邮寄，2-自取")
    public Integer getHandleType() {
        return handleType;
    }

    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }

    @JsonIgnore
    public HandleBackBillRequest backReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    /**
     * 原因
     *
     * @return backReason
     **/
    @ApiModelProperty(value = "原因")
    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    @JsonIgnore
    public HandleBackBillRequest waybillNo(String waybillNo) {
        this.waybillNo = waybillNo;
        return this;
    }

    /**
     * 运单号
     *
     * @return waybillNo
     **/
    @ApiModelProperty(value = "运单号")
    public String getWaybillNo() {
        return waybillNo;
    }

    public void setWaybillNo(String waybillNo) {
        this.waybillNo = waybillNo;
    }

    @JsonIgnore
    public HandleBackBillRequest expressName(String expressName) {
        this.expressName = expressName;
        return this;
    }

    /**
     * 快递公司
     *
     * @return expressName
     **/
    @ApiModelProperty(value = "快递公司")
    public String getExpressName() {
        return expressName;
    }

    public void setExpressName(String expressName) {
        this.expressName = expressName;
    }

    @JsonIgnore
    public HandleBackBillRequest backTime(Long backTime) {
        this.backTime = backTime;
        return this;
    }

    /**
     * 退回时间
     *
     * @return backTime
     **/
    @ApiModelProperty(value = "退回时间")
    public Long getBackTime() {
        return backTime;
    }

    public void setBackTime(Long backTime) {
        this.backTime = backTime;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HandleBackBillRequest handleBackBillRequest = (HandleBackBillRequest) o;
        return Objects.equals(this.billCode, handleBackBillRequest.billCode) &&
            Objects.equals(this.imageId, handleBackBillRequest.imageId) &&
            Objects.equals(this.handleType, handleBackBillRequest.handleType) &&
            Objects.equals(this.backReason, handleBackBillRequest.backReason) &&
            Objects.equals(this.waybillNo, handleBackBillRequest.waybillNo) &&
            Objects.equals(this.expressName, handleBackBillRequest.expressName) &&
            Objects.equals(this.backTime, handleBackBillRequest.backTime) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, imageId, handleType, backReason, waybillNo, expressName, backTime, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HandleBackBillRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    handleType: ").append(toIndentedString(handleType)).append("\n");
        sb.append("    backReason: ").append(toIndentedString(backReason)).append("\n");
        sb.append("    waybillNo: ").append(toIndentedString(waybillNo)).append("\n");
        sb.append("    expressName: ").append(toIndentedString(expressName)).append("\n");
        sb.append("    backTime: ").append(toIndentedString(backTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
