package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 重新验真Request
 */
@ApiModel(description = "重新验真Request")

@JsonInclude(NON_NULL)
public class ReVerifyRequest extends BaseRequest {

    @JsonProperty("type")
    private Integer type = null;

    @JsonProperty("handle")
    private Integer handle = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("checkRequestTime")
    private Long checkRequestTime = null;

    @JsonIgnore
    public ReVerifyRequest type(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * 1-单据，2-单证
     *
     * @return type
     **/
    @ApiModelProperty(value = "1-单据，2-单证")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @JsonIgnore
    public ReVerifyRequest handle(Integer handle) {
        this.handle = handle;
        return this;
    }

    /**
     * 1-补明细，2-下发
     *
     * @return handle
     **/
    @ApiModelProperty(value = "1-补明细，2-下发")
    public Integer getHandle() {
        return handle;
    }

    public void setHandle(Integer handle) {
        this.handle = handle;
    }

    @JsonIgnore
    public ReVerifyRequest ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 单证code
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "单证code")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }

    @JsonIgnore
    public ReVerifyRequest checkRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
        return this;
    }

    /**
     * 验真请求时间
     *
     * @return checkRequestTime
     **/
    @ApiModelProperty(value = "验真请求时间")
    public Long getCheckRequestTime() {
        return checkRequestTime;
    }

    public void setCheckRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReVerifyRequest reVerifyRequest = (ReVerifyRequest) o;
        return Objects.equals(this.type, reVerifyRequest.type) &&
            Objects.equals(this.handle, reVerifyRequest.handle) &&
            Objects.equals(this.ticketCode, reVerifyRequest.ticketCode) &&
            Objects.equals(this.checkRequestTime, reVerifyRequest.checkRequestTime) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, handle, ticketCode, checkRequestTime, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReVerifyRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    handle: ").append(toIndentedString(handle)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("    checkRequestTime: ").append(toIndentedString(checkRequestTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
