package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 修改标签启用停用Request
 */
@ApiModel(description = "修改标签启用停用Request")

@JsonInclude(NON_NULL)
public class UpdateLabelStatusRequest extends BaseRequest {

    @JsonProperty("labelIds")
    private List<Long> labelIds = new ArrayList<Long>();

    @JsonProperty("enable")
    private String enable = null;

    @JsonIgnore
    public UpdateLabelStatusRequest labelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public UpdateLabelStatusRequest addLabelIdsItem(Long labelIdsItem) {
        this.labelIds.add(labelIdsItem);
        return this;
    }

    /**
     * 标签id集合
     *
     * @return labelIds
     **/
    @ApiModelProperty(value = "标签id集合")
    public List<Long> getLabelIds() {
        return labelIds;
    }

    public void setLabelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    @JsonIgnore
    public UpdateLabelStatusRequest enable(String enable) {
        this.enable = enable;
        return this;
    }

    /**
     * 是否启用：0-禁用，1-启用
     *
     * @return enable
     **/
    @ApiModelProperty(value = "是否启用：0-禁用，1-启用")
    public String getEnable() {
        return enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateLabelStatusRequest updateLabelStatusRequest = (UpdateLabelStatusRequest) o;
        return Objects.equals(this.labelIds, updateLabelStatusRequest.labelIds) &&
            Objects.equals(this.enable, updateLabelStatusRequest.enable) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(labelIds, enable, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateLabelStatusRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    labelIds: ").append(toIndentedString(labelIds)).append("\n");
        sb.append("    enable: ").append(toIndentedString(enable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
