package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.CheckRuleCodeRepeatRequest;
import com.xforceplus.elephant.image.client.model.GetBatchNumberRuleRequest;
import com.xforceplus.elephant.image.client.model.GetSerialNumberRequest;
import com.xforceplus.elephant.image.client.model.SaveBatchNumberRuleRequest;
import com.xforceplus.elephant.image.client.model.SaveSerialNumberRequest;
import com.xforceplus.elephant.image.client.model.UpdateBatchNumberRuleRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value = "batchNumberRule", description = "the batchNumberRule API", tags = "batchNumberRule")
public interface BatchNumberRuleApi {

    @ApiOperation(value = "新增批次号规则", notes = "新增批次号规则", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/add",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse addBatchNumberRule(@ApiParam(value = "request", required = true) @Valid SaveBatchNumberRuleRequest request
    );

    @ApiOperation(value = "修改批次号规则", notes = "修改批次号规则", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/edit",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse editBatchNumberRule(@ApiParam(value = "request", required = true) @Valid UpdateBatchNumberRuleRequest request
    );

    @ApiOperation(value = "通过规则编码校验是否存在", notes = "通过规则编码校验是否存在", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/checkRepeatByCode",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse checkRepeatByCode(@ApiParam(value = "request", required = true) @Valid CheckRuleCodeRepeatRequest request
    );

    @ApiOperation(value = "查询批次号规则", notes = "查询批次号规则", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/get",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBatchNumberRule(@ApiParam(value = "request", required = true) @Valid GetBatchNumberRuleRequest request
    );

    @ApiOperation(value = "获取流水号", notes = "获取流水号", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/getSerialNumber",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getSerialNumber(@ApiParam(value = "request", required = true) @Valid GetSerialNumberRequest request
    );

    @ApiOperation(value = "保存流水号", notes = "保存流水号", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/saveSerialNumber",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveSerialNumber(@ApiParam(value = "request", required = true) @Valid SaveSerialNumberRequest request
    );

    @ApiOperation(value = "获取规则编号配置", notes = "获取规则编号配置", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/config/ruleCode",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getRuleCodeConfig(
    );

    @ApiOperation(value = "获取枚举配置", notes = "获取枚举配置", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/config/enums",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getEnumsConfig(
    );


    @ApiOperation(value = "获取枚举详情配置", notes = "获取枚举详情配置", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/config/enumDetails",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getEnumDetailsConfig(@ApiParam(value = "枚举值", required = true) @RequestParam("enumValue") String enumValue
    );

    @ApiOperation(value = "批量获取枚举详情配置", notes = "批量枚举详情配置", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/config/enumDetails/batch",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse batchGetEnumDetailsConfig(@ApiParam(value = "枚举值", required = true) @RequestParam("enumValues") String[] enumValues
    );

    @ApiOperation(value = "获取无规则流水号", notes = "获取无规则流水号", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/batchNumberRule/getNoRuleSerialNumber",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getNoRuleSerialNumber(@ApiParam(value = "request", required = true) @Valid GetSerialNumberRequest request
    );


}
