package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetLogisticsListRequest;
import com.xforceplus.elephant.image.client.model.SaveLogisticsRequest;
import com.xforceplus.elephant.image.client.model.UpdateLogisticsRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "logistics", description = "the logistics API", tags = "logistics")
public interface LogisticsApi {

    @ApiOperation(value = "删除物流信息", notes = "删除物流信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "删除结果")})
    @RequestMapping(value = "/logistics/{logisticsId}",
        produces = {"application/json"},
        method = RequestMethod.DELETE)
    CommonResponse deleteLogistics(@ApiParam(value = "自增主键", required = true) @PathVariable("logisticsId") Long logisticsId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取物流详情", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/logistics/{logisticsId}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogisticsDetail(@ApiParam(value = "自增主键", required = true) @PathVariable("logisticsId") Long logisticsId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取物流列表", notes = "获取物流数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/logistics",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogisticsList(@ApiParam(value = "request", required = true) @Valid GetLogisticsListRequest request
    );


    @ApiOperation(value = "新增物流", notes = "新增物流", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/logistics",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveLogistics(@ApiParam(value = "request", required = true) @Valid SaveLogisticsRequest request
    );


    @ApiOperation(value = "更新物流信息", notes = "更新物流信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "更新结果")})
    @RequestMapping(value = "/logistics",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse updateLogistics(@ApiParam(value = "request", required = true) @Valid UpdateLogisticsRequest request
    );

}
