package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 单据批量提交接口
 */
@ApiModel(description = "单据批量提交接口")

@JsonInclude(NON_NULL)
public class BaseBillCommitRequest extends BaseRequest {

    @JsonProperty("entities")
    private List<EntityObj> entities = new ArrayList<EntityObj>();

    private String backRemark;

    /**
     * 0或者空，默认提交，1-无需退回
     */
    private Integer type;
    /**
     * 检测收单状态
     */
    private boolean checkReceiveStatus = false;
    /**
     * 提交备注
     */
    private String commitRemark;

    @JsonIgnore
    public BaseBillCommitRequest entities(List<EntityObj> entities) {
        this.entities = entities;
        return this;
    }

    public BaseBillCommitRequest addEntitiesItem(EntityObj entitiesItem) {
        this.entities.add(entitiesItem);
        return this;
    }

    /**
     * 集合
     *
     * @return entities
     **/
    @ApiModelProperty(value = "集合")
    public List<EntityObj> getEntities() {
        return entities;
    }

    public void setEntities(List<EntityObj> entities) {
        this.entities = entities;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseBillCommitRequest baseBillCommitRequest = (BaseBillCommitRequest) o;
        return Objects.equals(this.entities, baseBillCommitRequest.entities) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entities, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseBillCommitRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getBackRemark() {
        return backRemark;
    }

    public void setBackRemark(String backRemark) {
        this.backRemark = backRemark;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public boolean isCheckReceiveStatus() {
        return checkReceiveStatus;
    }

    public void setCheckReceiveStatus(boolean checkReceiveStatus) {
        this.checkReceiveStatus = checkReceiveStatus;
    }

    public String getCommitRemark() {
        return commitRemark;
    }

    public void setCommitRemark(String commitRemark) {
        this.commitRemark = commitRemark;
    }

}
