package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 清除单证结构数据Request
 */
@ApiModel(description = "清除单证结构数据Request")

@JsonInclude(NON_NULL)
public class ClearTicketDataRequest extends BaseRequest {

    @JsonProperty("ticketId")
    private Long ticketId = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonIgnore
    public ClearTicketDataRequest ticketId(Long ticketId) {
        this.ticketId = ticketId;
        return this;
    }

    /**
     * 单证ID
     *
     * @return ticketId
     **/
    @ApiModelProperty(value = "单证ID")
    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    @JsonIgnore
    public ClearTicketDataRequest ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 单证code
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "单证code")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClearTicketDataRequest clearTicketDataRequest = (ClearTicketDataRequest) o;
        return Objects.equals(this.ticketId, clearTicketDataRequest.ticketId) &&
            Objects.equals(this.ticketCode, clearTicketDataRequest.ticketCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketId, ticketCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClearTicketDataRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    ticketId: ").append(toIndentedString(ticketId)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
