package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 获取单据下的单证
 */
@ApiModel(description = "获取单据下的单证")

@JsonInclude(NON_NULL)
public class GetTicketListRequest extends BaseRequest {

    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("type")
    private Integer type = null;

    @JsonIgnore
    public GetTicketListRequest billCodes(List<String> billCodes) {
        this.billCodes = billCodes;
        return this;
    }

    public GetTicketListRequest addBillCodesItem(String billCodesItem) {
        this.billCodes.add(billCodesItem);
        return this;
    }

    /**
     * 单据codes
     *
     * @return billCodes
     **/
    @ApiModelProperty(value = "单据codes")
    public List<String> getBillCodes() {
        return billCodes;
    }

    public void setBillCodes(List<String> billCodes) {
        this.billCodes = billCodes;
    }

    @JsonIgnore
    public GetTicketListRequest pageCode(String pageCode) {
        this.pageCode = pageCode;
        return this;
    }

    /**
     * 页面code
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "页面code")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    @JsonIgnore
    public GetTicketListRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像id
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像id")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public GetTicketListRequest type(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * 类型 为空、默认走逻辑 1直接生成封面清单列表,2-单个影像提交
     *
     * @return type
     **/
    @ApiModelProperty(value = "类型 为空、默认走逻辑 1直接生成封面清单列表,2-单个影像提交")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetTicketListRequest getTicketListRequest = (GetTicketListRequest) o;
        return Objects.equals(this.billCodes, getTicketListRequest.billCodes) &&
            Objects.equals(this.pageCode, getTicketListRequest.pageCode) &&
            Objects.equals(this.imageId, getTicketListRequest.imageId) &&
            Objects.equals(this.type, getTicketListRequest.type) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCodes, pageCode, imageId, type, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTicketListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCodes: ").append(toIndentedString(billCodes)).append("\n");
        sb.append("    pageCode: ").append(toIndentedString(pageCode)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
