package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 重试logApiRequest
 */
@ApiModel(description = "重试logApiRequest")

@JsonInclude(NON_NULL)
public class RetryLogApiRequest extends BaseRequest {

    @JsonProperty("logId")
    private Long logId = null;

    @JsonProperty("requestParams")
    private String requestParams = null;

    @JsonIgnore
    public RetryLogApiRequest logId(Long logId) {
        this.logId = logId;
        return this;
    }

    /**
     * logId
     *
     * @return logId
     **/
    @ApiModelProperty(value = "logId")
    public Long getLogId() {
        return logId;
    }

    public void setLogId(Long logId) {
        this.logId = logId;
    }

    @JsonIgnore
    public RetryLogApiRequest requestParams(String requestParams) {
        this.requestParams = requestParams;
        return this;
    }

    /**
     * 请求参数
     *
     * @return requestParams
     **/
    @ApiModelProperty(value = "请求参数")
    public String getRequestParams() {
        return requestParams;
    }

    public void setRequestParams(String requestParams) {
        this.requestParams = requestParams;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RetryLogApiRequest retryLogApiRequest = (RetryLogApiRequest) o;
        return Objects.equals(this.logId, retryLogApiRequest.logId) &&
            Objects.equals(this.requestParams, retryLogApiRequest.requestParams) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(logId, requestParams, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RetryLogApiRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    logId: ").append(toIndentedString(logId)).append("\n");
        sb.append("    requestParams: ").append(toIndentedString(requestParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
