package com.xforceplus.elephant.image.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import lombok.Data;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/11/6 15:53
 */
@ApiModel(description = "一票多用分享")
@Data
public class ShareImageRequest {

    @ApiModelProperty(value = "单证ID")
    @NotNull
    @Positive
    private Long ticketId;

    @NotEmpty(message = "必须选择分享人")
    @ApiModelProperty(value = "分享的userIds")
    private List<Long> shareUserIds;

}
