package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 更新核验签收状态请求
 */
@ApiModel(description = "更新核验签收状态请求")

@JsonInclude(NON_NULL)
public class UpdateVerifyStatusRequest extends BaseRequest {

    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    @JsonProperty("verifyStatus")
    private Integer verifyStatus = null;

    @JsonProperty("verfiyHangType")
    private Integer verfiyHangType = null;

    @JsonProperty("verfiyHangReason")
    private String verfiyHangReason = null;

    @JsonProperty("unqualityType")
    private Integer unqualityType = null;

    @JsonProperty("unqualityReason")
    private String unqualityReason = null;

    @JsonIgnore
    public UpdateVerifyStatusRequest billCodes(List<String> billCodes) {
        this.billCodes = billCodes;
        return this;
    }

    public UpdateVerifyStatusRequest addBillCodesItem(String billCodesItem) {
        this.billCodes.add(billCodesItem);
        return this;
    }

    /**
     * 单据code集合
     *
     * @return billCodes
     **/
    @ApiModelProperty(value = "单据code集合")
    public List<String> getBillCodes() {
        return billCodes;
    }

    public void setBillCodes(List<String> billCodes) {
        this.billCodes = billCodes;
    }

    @JsonIgnore
    public UpdateVerifyStatusRequest verifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
        return this;
    }

    /**
     * 核验签收状态
     *
     * @return verifyStatus
     **/
    @ApiModelProperty(value = "核验签收状态")
    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    @JsonIgnore
    public UpdateVerifyStatusRequest verfiyHangType(Integer verfiyHangType) {
        this.verfiyHangType = verfiyHangType;
        return this;
    }

    /**
     * 挂起类型
     *
     * @return verfiyHangType
     **/
    @ApiModelProperty(value = "挂起类型")
    public Integer getVerfiyHangType() {
        return verfiyHangType;
    }

    public void setVerfiyHangType(Integer verfiyHangType) {
        this.verfiyHangType = verfiyHangType;
    }

    @JsonIgnore
    public UpdateVerifyStatusRequest verfiyHangReason(String verfiyHangReason) {
        this.verfiyHangReason = verfiyHangReason;
        return this;
    }

    /**
     * 挂起原因
     *
     * @return verfiyHangReason
     **/
    @ApiModelProperty(value = "挂起原因")
    public String getVerfiyHangReason() {
        return verfiyHangReason;
    }

    public void setVerfiyHangReason(String verfiyHangReason) {
        this.verfiyHangReason = verfiyHangReason;
    }

    @JsonIgnore
    public UpdateVerifyStatusRequest unqualityType(Integer unqualityType) {
        this.unqualityType = unqualityType;
        return this;
    }

    /**
     * 不合格类型
     *
     * @return unqualityType
     **/
    @ApiModelProperty(value = "不合格类型")
    public Integer getUnqualityType() {
        return unqualityType;
    }

    public void setUnqualityType(Integer unqualityType) {
        this.unqualityType = unqualityType;
    }

    @JsonIgnore
    public UpdateVerifyStatusRequest unqualityReason(String unqualityReason) {
        this.unqualityReason = unqualityReason;
        return this;
    }

    /**
     * 不合格原因
     *
     * @return unqualityReason
     **/
    @ApiModelProperty(value = "不合格原因")
    public String getUnqualityReason() {
        return unqualityReason;
    }

    public void setUnqualityReason(String unqualityReason) {
        this.unqualityReason = unqualityReason;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateVerifyStatusRequest updateVerifyStatusRequest = (UpdateVerifyStatusRequest) o;
        return Objects.equals(this.billCodes, updateVerifyStatusRequest.billCodes) &&
            Objects.equals(this.verifyStatus, updateVerifyStatusRequest.verifyStatus) &&
            Objects.equals(this.verfiyHangType, updateVerifyStatusRequest.verfiyHangType) &&
            Objects.equals(this.verfiyHangReason, updateVerifyStatusRequest.verfiyHangReason) &&
            Objects.equals(this.unqualityType, updateVerifyStatusRequest.unqualityType) &&
            Objects.equals(this.unqualityReason, updateVerifyStatusRequest.unqualityReason) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCodes, verifyStatus, verfiyHangType, verfiyHangReason, unqualityType, unqualityReason, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateVerifyStatusRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCodes: ").append(toIndentedString(billCodes)).append("\n");
        sb.append("    verifyStatus: ").append(toIndentedString(verifyStatus)).append("\n");
        sb.append("    verfiyHangType: ").append(toIndentedString(verfiyHangType)).append("\n");
        sb.append("    verfiyHangReason: ").append(toIndentedString(verfiyHangReason)).append("\n");
        sb.append("    unqualityType: ").append(toIndentedString(unqualityType)).append("\n");
        sb.append("    unqualityReason: ").append(toIndentedString(unqualityReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
