package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 下载文件请求
 */
@ApiModel(description = "下载文件请求")

@JsonInclude(NON_NULL)
public class UploadFileRequest extends BaseRequest {

    @JsonProperty("ticketSourceFileIds")
    private List<Long> ticketSourceFileIds = new ArrayList<Long>();

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonIgnore
    public UploadFileRequest ticketSourceFileIds(List<Long> ticketSourceFileIds) {
        this.ticketSourceFileIds = ticketSourceFileIds;
        return this;
    }

    public UploadFileRequest addTicketSourceFileIdsItem(Long ticketSourceFileIdsItem) {
        this.ticketSourceFileIds.add(ticketSourceFileIdsItem);
        return this;
    }

    /**
     * ticketSourceFileIds
     *
     * @return ticketSourceFileIds
     **/
    @ApiModelProperty(value = "ticketSourceFileIds")
    public List<Long> getTicketSourceFileIds() {
        return ticketSourceFileIds;
    }

    public void setTicketSourceFileIds(List<Long> ticketSourceFileIds) {
        this.ticketSourceFileIds = ticketSourceFileIds;
    }

    @JsonIgnore
    public UploadFileRequest invoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
        return this;
    }

    /**
     * 发票号码
     *
     * @return invoiceNo
     **/
    @ApiModelProperty(value = "发票号码")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @JsonIgnore
    public UploadFileRequest invoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
        return this;
    }

    /**
     * 发票代码
     *
     * @return invoiceCode
     **/
    @ApiModelProperty(value = "发票代码")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UploadFileRequest uploadFileRequest = (UploadFileRequest) o;
        return Objects.equals(this.ticketSourceFileIds, uploadFileRequest.ticketSourceFileIds) &&
            Objects.equals(this.invoiceNo, uploadFileRequest.invoiceNo) &&
            Objects.equals(this.invoiceCode, uploadFileRequest.invoiceCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketSourceFileIds, invoiceNo, invoiceCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadFileRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    ticketSourceFileIds: ").append(toIndentedString(ticketSourceFileIds)).append("\n");
        sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
        sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
