package com.xforceplus.elephant.image.client.model;

import io.swagger.annotations.ApiModel;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import lombok.Data;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/12/27 13:20
 */
@ApiModel(description = "编辑占用金额")
@Data
public class UsedAmountRequest {

    @Min(value = 1, message = "【ticketId】不能为空")
    private long ticketId;

    @Pattern(regexp = "^([0-9]+(.[0-9]+)?)?$", message = "【usedAmount】必须是金额")
    private String usedAmount;

}
