package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/6/14 15:18
 */
public interface ErrorCodeApi {

    @ApiOperation(value = "错误码列表", notes = "错误码列表")
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/project-api/error-codes",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse listErrorCodes();

    @ApiOperation(value = "更新错误码提示语")
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/project-api/{apiId}/{errorCode}/message",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse editErrorCodeMessage(@PathVariable("apiId") Long apiId, @PathVariable("errorCode") String errorCode, @RequestParam String message);

}
