package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.image.client.model.UploadFileRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "ticketSourceFile", description = "the ticketSourceFile API", tags = "ticketSourceFile")
public interface TicketSourceFileApi {

    @ApiOperation(value = "获取电票源文件下载文件", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/ticketSourceFile/uploadFile",
        produces = {"application/octet-stream"},
        method = RequestMethod.GET)
    Object uploadFile(@ApiParam(value = "request", required = true) @Valid UploadFileRequest request
    );

}
