package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 单据批量删除接口ReturnBillDataRequest
 */
@ApiModel(description = "单据批量删除接口ReturnBillDataRequest")

@JsonInclude(NON_NULL)
public class BillDataDeleteRequest extends BaseRequest {

    @JsonProperty("billDataIds")
    private List<Long> billDataIds = new ArrayList<Long>();

    @JsonIgnore
    public BillDataDeleteRequest billDataIds(List<Long> billDataIds) {
        this.billDataIds = billDataIds;
        return this;
    }

    public BillDataDeleteRequest addBillDataIdsItem(Long billDataIdsItem) {
        this.billDataIds.add(billDataIdsItem);
        return this;
    }

    /**
     * 单据id集合
     *
     * @return billDataIds
     **/
    @ApiModelProperty(value = "单据id集合")
    public List<Long> getBillDataIds() {
        return billDataIds;
    }

    public void setBillDataIds(List<Long> billDataIds) {
        this.billDataIds = billDataIds;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BillDataDeleteRequest billDataDeleteRequest = (BillDataDeleteRequest) o;
        return Objects.equals(this.billDataIds, billDataDeleteRequest.billDataIds) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billDataIds, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillDataDeleteRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billDataIds: ").append(toIndentedString(billDataIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
