package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 单据数据对象
 */
@ApiModel(description = "单据数据对象")

@JsonInclude(NON_NULL)
public class TicketDataObj {

    @JsonProperty("ticketId")
    private Long ticketId = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonIgnore
    public TicketDataObj ticketId(Long ticketId) {
        this.ticketId = ticketId;
        return this;
    }

    /**
     * 单证ID
     *
     * @return ticketId
     **/
    @ApiModelProperty(value = "单证ID")
    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    @JsonIgnore
    public TicketDataObj ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 单证code
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "单证code")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketDataObj ticketDataObj = (TicketDataObj) o;
        return Objects.equals(this.ticketId, ticketDataObj.ticketId) &&
            Objects.equals(this.ticketCode, ticketDataObj.ticketCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketId, ticketCode);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TicketDataObj {\n");

        sb.append("    ticketId: ").append(toIndentedString(ticketId)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
