package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * 单据数据
 */
@ApiModel(description = "单据数据")

@JsonInclude(NON_NULL)
public class BaseBillDTO {

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("billTypeCode")
    private String billTypeCode = null;

    @JsonProperty("billTypeName")
    private String billTypeName = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("billAmountWithTax")
    private BigDecimal billAmountWithTax = null;

    @JsonProperty("billTaxAmount")
    private BigDecimal billTaxAmount = null;

    @JsonProperty("billAmountWithoutTax")
    private BigDecimal billAmountWithoutTax = null;

    @JsonProperty("billCreateUser")
    private String billCreateUser = null;

    @JsonProperty("billCreateTime")
    private Long billCreateTime = null;

    @JsonProperty("scanUserId")
    private Long scanUserId = null;

    @JsonProperty("scanUserName")
    private String scanUserName = null;

    @JsonProperty("scanCreateTime")
    private Long scanCreateTime = null;

    @JsonProperty("packageCode")
    private String packageCode = null;

    @JsonProperty("logisticsStatus")
    private Integer logisticsStatus = null;

    @JsonProperty("logisticsTime")
    private Long logisticsTime = null;

    @JsonProperty("logisticRemark")
    private String logisticRemark = null;

    @JsonProperty("signStatus")
    private Integer signStatus = null;

    @JsonProperty("signTime")
    private Long signTime = null;

    @JsonProperty("isPublic")
    private String isPublic = null;

    @JsonProperty("isSecret")
    private Integer isSecret = null;

    @JsonProperty("hangType")
    private Integer hangType = null;

    @JsonProperty("hangReason")
    private String hangReason = null;

    @JsonProperty("hangTime")
    private Long hangTime = null;

    @JsonProperty("backType")
    private Integer backType = null;

    @JsonProperty("backReason")
    private String backReason = null;

    @JsonProperty("billDataStatus")
    private Integer billDataStatus = null;

    @JsonProperty("billDataTime")
    private Long billDataTime = null;

    @JsonProperty("verifyStatus")
    private Integer verifyStatus = null;

    @JsonProperty("verifyTime")
    private Long verifyTime = null;

    @JsonProperty("ticketCount")
    private Integer ticketCount = null;

    @JsonProperty("imageCount")
    private Integer imageCount = null;

    @JsonProperty("exceptionCount")
    private Integer exceptionCount = null;

    @JsonProperty("warningCount")
    private Integer warningCount = null;

    @JsonProperty("isException")
    private Integer isException = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("systemOrig")
    private String systemOrig = null;

    @JsonProperty("backRemark")
    private String backRemark = null;

    @JsonProperty("unqualityType")
    private Integer unqualityType = null;

    @JsonProperty("unqualityReason")
    private String unqualityReason = null;

    @JsonProperty("verifyHangType")
    private Integer verifyHangType = null;

    @JsonProperty("verifyHangReason")
    private String verifyHangReason = null;

    @JsonProperty("isPrepayment")
    private Integer isPrepayment = null;

    @JsonProperty("extFields")
    private String extFields = null;

    @JsonProperty("extStatus")
    private Integer extStatus = null;

    @JsonProperty("prepaymentStatus")
    private Integer prepaymentStatus = null;

    @JsonProperty("prepaymentTime")
    private Long prepaymentTime = null;

    @JsonProperty("macthStatus")
    private Integer macthStatus = null;

    @JsonProperty("createUserCode")
    private String createUserCode = null;

    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;

    @JsonProperty("sellerName")
    private String sellerName = null;

    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;

    @JsonProperty("purchaserName")
    private String purchaserName = null;

    @JsonProperty("serialNumber")
    private String serialNumber = null;

    @JsonProperty("billCheckStatus")
    private Integer billCheckStatus = null;

    @JsonProperty("purchaserCode")
    private String purchaserCode = null;

    @JsonProperty("billCheckTime")
    private Long billCheckTime = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("sellerCode")
    private String sellerCode = null;

    @JsonProperty("reserved1")
    private String reserved1 = null;

    @JsonProperty("reserved2")
    private String reserved2 = null;

    @JsonProperty("reserved3")
    private String reserved3 = null;

    @JsonProperty("isCommit")
    private Integer isCommit = null;

    @JsonProperty("commitUserId")
    private Long commitUserId = null;

    @JsonProperty("commitUserName")
    private String commitUserName = null;

    @JsonProperty("commitTime")
    private Long commitTime = null;

    @JsonProperty("businessType")
    private String businessType = null;

    @JsonProperty("billUse")
    private String billUse = null;

    @JsonProperty("businessTypeName")
    private String businessTypeName = null;

    private String warningInfo;

    private Integer isWarning;

    private String relWarningInfo;

    private String relExceptionInfo;


    private Integer calculateStatus = null;

    private Integer isPushBill;

    private String ticketException;
    private String ticketWarning;

    public Integer getIsPushBill() {
        return isPushBill;
    }

    public void setIsPushBill(Integer isPushBill) {
        this.isPushBill = isPushBill;
    }

    public String getWarningInfo() {
        return warningInfo;
    }

    public void setWarningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
    }

    public Integer getIsWarning() {
        return isWarning;
    }

    public void setIsWarning(Integer isWarning) {
        this.isWarning = isWarning;
    }

    public String getRelWarningInfo() {
        return relWarningInfo;
    }

    public void setRelWarningInfo(String relWarningInfo) {
        this.relWarningInfo = relWarningInfo;
    }

    public String getRelExceptionInfo() {
        return relExceptionInfo;
    }

    public void setRelExceptionInfo(String relExceptionInfo) {
        this.relExceptionInfo = relExceptionInfo;
    }

    public Integer getCalculateStatus() {
        return calculateStatus;
    }

    public void setCalculateStatus(Integer calculateStatus) {
        this.calculateStatus = calculateStatus;
    }


    @JsonIgnore
    public BaseBillDTO id(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 自增主键
     *
     * @return id
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public BaseBillDTO tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public BaseBillDTO imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public BaseBillDTO batchNo(String batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    /**
     * 批次号
     *
     * @return batchNo
     **/
    @ApiModelProperty(value = "批次号")
    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public BaseBillDTO billTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
        return this;
    }

    /**
     * 单据类型code
     *
     * @return billTypeCode
     **/
    @ApiModelProperty(value = "单据类型code")
    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    @JsonIgnore
    public BaseBillDTO billTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
        return this;
    }

    /**
     * 单据类型名称
     *
     * @return billTypeName
     **/
    @ApiModelProperty(value = "单据类型名称")
    public String getBillTypeName() {
        return billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    @JsonIgnore
    public BaseBillDTO billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public BaseBillDTO billAmountWithTax(BigDecimal billAmountWithTax) {
        this.billAmountWithTax = billAmountWithTax;
        return this;
    }

    /**
     * 单据金额
     *
     * @return billAmountWithTax
     **/
    @ApiModelProperty(value = "单据金额")
    public BigDecimal getBillAmountWithTax() {
        return billAmountWithTax;
    }

    public void setBillAmountWithTax(BigDecimal billAmountWithTax) {
        this.billAmountWithTax = billAmountWithTax;
    }

    @JsonIgnore
    public BaseBillDTO billTaxAmount(BigDecimal billTaxAmount) {
        this.billTaxAmount = billTaxAmount;
        return this;
    }

    /**
     * 单据含税金额
     *
     * @return billTaxAmount
     **/
    @ApiModelProperty(value = "单据含税金额")
    public BigDecimal getBillTaxAmount() {
        return billTaxAmount;
    }

    public void setBillTaxAmount(BigDecimal billTaxAmount) {
        this.billTaxAmount = billTaxAmount;
    }

    @JsonIgnore
    public BaseBillDTO billAmountWithoutTax(BigDecimal billAmountWithoutTax) {
        this.billAmountWithoutTax = billAmountWithoutTax;
        return this;
    }

    /**
     * 单据不含税金额
     *
     * @return billAmountWithoutTax
     **/
    @ApiModelProperty(value = "单据不含税金额")
    public BigDecimal getBillAmountWithoutTax() {
        return billAmountWithoutTax;
    }

    public void setBillAmountWithoutTax(BigDecimal billAmountWithoutTax) {
        this.billAmountWithoutTax = billAmountWithoutTax;
    }

    @JsonIgnore
    public BaseBillDTO billCreateUser(String billCreateUser) {
        this.billCreateUser = billCreateUser;
        return this;
    }

    /**
     * 提单人
     *
     * @return billCreateUser
     **/
    @ApiModelProperty(value = "提单人")
    public String getBillCreateUser() {
        return billCreateUser;
    }

    public void setBillCreateUser(String billCreateUser) {
        this.billCreateUser = billCreateUser;
    }

    @JsonIgnore
    public BaseBillDTO billCreateTime(Long billCreateTime) {
        this.billCreateTime = billCreateTime;
        return this;
    }

    /**
     * 提单时间
     *
     * @return billCreateTime
     **/
    @ApiModelProperty(value = "提单时间")
    public Long getBillCreateTime() {
        return billCreateTime;
    }

    public void setBillCreateTime(Long billCreateTime) {
        this.billCreateTime = billCreateTime;
    }

    @JsonIgnore
    public BaseBillDTO scanUserId(Long scanUserId) {
        this.scanUserId = scanUserId;
        return this;
    }

    /**
     * 扫描人ID
     *
     * @return scanUserId
     **/
    @ApiModelProperty(value = "扫描人ID")
    public Long getScanUserId() {
        return scanUserId;
    }

    public void setScanUserId(Long scanUserId) {
        this.scanUserId = scanUserId;
    }

    @JsonIgnore
    public BaseBillDTO scanUserName(String scanUserName) {
        this.scanUserName = scanUserName;
        return this;
    }

    /**
     * 扫描人姓名
     *
     * @return scanUserName
     **/
    @ApiModelProperty(value = "扫描人姓名")
    public String getScanUserName() {
        return scanUserName;
    }

    public void setScanUserName(String scanUserName) {
        this.scanUserName = scanUserName;
    }

    @JsonIgnore
    public BaseBillDTO scanCreateTime(Long scanCreateTime) {
        this.scanCreateTime = scanCreateTime;
        return this;
    }

    /**
     * 扫描时间
     *
     * @return scanCreateTime
     **/
    @ApiModelProperty(value = "扫描时间")
    public Long getScanCreateTime() {
        return scanCreateTime;
    }

    public void setScanCreateTime(Long scanCreateTime) {
        this.scanCreateTime = scanCreateTime;
    }

    @JsonIgnore
    public BaseBillDTO packageCode(String packageCode) {
        this.packageCode = packageCode;
        return this;
    }

    /**
     * 运单号
     *
     * @return packageCode
     **/
    @ApiModelProperty(value = "运单号")
    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    @JsonIgnore
    public BaseBillDTO logisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
        return this;
    }

    /**
     * 物流状态 0-待寄送，1-已寄送 2-无需寄送
     *
     * @return logisticsStatus
     **/
    @ApiModelProperty(value = "物流状态 0-待寄送，1-已寄送 2-无需寄送")
    public Integer getLogisticsStatus() {
        return logisticsStatus;
    }

    public void setLogisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    @JsonIgnore
    public BaseBillDTO logisticsTime(Long logisticsTime) {
        this.logisticsTime = logisticsTime;
        return this;
    }

    /**
     * 寄送时间
     *
     * @return logisticsTime
     **/
    @ApiModelProperty(value = "寄送时间")
    public Long getLogisticsTime() {
        return logisticsTime;
    }

    public void setLogisticsTime(Long logisticsTime) {
        this.logisticsTime = logisticsTime;
    }

    @JsonIgnore
    public BaseBillDTO logisticRemark(String logisticRemark) {
        this.logisticRemark = logisticRemark;
        return this;
    }

    /**
     * 物流备注
     *
     * @return logisticRemark
     **/
    @ApiModelProperty(value = "物流备注")
    public String getLogisticRemark() {
        return logisticRemark;
    }

    public void setLogisticRemark(String logisticRemark) {
        this.logisticRemark = logisticRemark;
    }

    @JsonIgnore
    public BaseBillDTO signStatus(Integer signStatus) {
        this.signStatus = signStatus;
        return this;
    }

    /**
     * 签收状态：0-未签收，1-签收成功，2-签收失败
     *
     * @return signStatus
     **/
    @ApiModelProperty(value = "签收状态：0-未签收，1-签收成功，2-签收失败")
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    @JsonIgnore
    public BaseBillDTO signTime(Long signTime) {
        this.signTime = signTime;
        return this;
    }

    /**
     * 签收时间
     *
     * @return signTime
     **/
    @ApiModelProperty(value = "签收时间")
    public Long getSignTime() {
        return signTime;
    }

    public void setSignTime(Long signTime) {
        this.signTime = signTime;
    }

    @JsonIgnore
    public BaseBillDTO isPublic(String isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    /**
     * 是否公共：0-否，1-是
     *
     * @return isPublic
     **/
    @ApiModelProperty(value = "是否公共：0-否，1-是")
    public String getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(String isPublic) {
        this.isPublic = isPublic;
    }

    @JsonIgnore
    public BaseBillDTO isSecret(Integer isSecret) {
        this.isSecret = isSecret;
        return this;
    }

    /**
     * 是否敏感：0-否，1-是
     *
     * @return isSecret
     **/
    @ApiModelProperty(value = "是否敏感：0-否，1-是")
    public Integer getIsSecret() {
        return isSecret;
    }

    public void setIsSecret(Integer isSecret) {
        this.isSecret = isSecret;
    }

    @JsonIgnore
    public BaseBillDTO hangType(Integer hangType) {
        this.hangType = hangType;
        return this;
    }

    /**
     * 挂起原因类型
     *
     * @return hangType
     **/
    @ApiModelProperty(value = "挂起原因类型")
    public Integer getHangType() {
        return hangType;
    }

    public void setHangType(Integer hangType) {
        this.hangType = hangType;
    }

    @JsonIgnore
    public BaseBillDTO hangReason(String hangReason) {
        this.hangReason = hangReason;
        return this;
    }

    /**
     * 挂起原因备注
     *
     * @return hangReason
     **/
    @ApiModelProperty(value = "挂起原因备注")
    public String getHangReason() {
        return hangReason;
    }

    public void setHangReason(String hangReason) {
        this.hangReason = hangReason;
    }

    @JsonIgnore
    public BaseBillDTO hangTime(Long hangTime) {
        this.hangTime = hangTime;
        return this;
    }

    /**
     * 挂起时间
     *
     * @return hangTime
     **/
    @ApiModelProperty(value = "挂起时间")
    public Long getHangTime() {
        return hangTime;
    }

    public void setHangTime(Long hangTime) {
        this.hangTime = hangTime;
    }

    @JsonIgnore
    public BaseBillDTO backType(Integer backType) {
        this.backType = backType;
        return this;
    }

    /**
     * 退回类型：1-审批驳回，2-核验退回
     *
     * @return backType
     **/
    @ApiModelProperty(value = "退回类型：1-审批驳回，2-核验退回")
    public Integer getBackType() {
        return backType;
    }

    public void setBackType(Integer backType) {
        this.backType = backType;
    }

    @JsonIgnore
    public BaseBillDTO backReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    /**
     * 退回原因
     *
     * @return backReason
     **/
    @ApiModelProperty(value = "退回原因")
    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    @JsonIgnore
    public BaseBillDTO billDataStatus(Integer billDataStatus) {
        this.billDataStatus = billDataStatus;
        return this;
    }

    /**
     * 单据状态：0-待提交，1-已提交，2-暂挂起，3-已锁定，4-已退回，5-已作废
     *
     * @return billDataStatus
     **/
    @ApiModelProperty(value = "单据状态：0-待提交，1-已提交，2-暂挂起，3-已锁定，4-已退回，5-已作废")
    public Integer getBillDataStatus() {
        return billDataStatus;
    }

    public void setBillDataStatus(Integer billDataStatus) {
        this.billDataStatus = billDataStatus;
    }

    @JsonIgnore
    public BaseBillDTO billDataTime(Long billDataTime) {
        this.billDataTime = billDataTime;
        return this;
    }

    /**
     * 状态变更时间
     *
     * @return billDataTime
     **/
    @ApiModelProperty(value = "状态变更时间")
    public Long getBillDataTime() {
        return billDataTime;
    }

    public void setBillDataTime(Long billDataTime) {
        this.billDataTime = billDataTime;
    }

    @JsonIgnore
    public BaseBillDTO verifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
        return this;
    }

    /**
     * 核验签收状态：0-待核验，1-核验合格，2-暂挂起，3-核验不合格
     *
     * @return verifyStatus
     **/
    @ApiModelProperty(value = "核验签收状态：0-待核验，1-核验合格，2-暂挂起，3-核验不合格")
    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    @JsonIgnore
    public BaseBillDTO verifyTime(Long verifyTime) {
        this.verifyTime = verifyTime;
        return this;
    }

    /**
     * 核验签收时间
     *
     * @return verifyTime
     **/
    @ApiModelProperty(value = "核验签收时间")
    public Long getVerifyTime() {
        return verifyTime;
    }

    public void setVerifyTime(Long verifyTime) {
        this.verifyTime = verifyTime;
    }

    @JsonIgnore
    public BaseBillDTO ticketCount(Integer ticketCount) {
        this.ticketCount = ticketCount;
        return this;
    }

    /**
     * 单据下的单证影像数量
     *
     * @return ticketCount
     **/
    @ApiModelProperty(value = "单据下的单证影像数量")
    public Integer getTicketCount() {
        return ticketCount;
    }

    public void setTicketCount(Integer ticketCount) {
        this.ticketCount = ticketCount;
    }

    @JsonIgnore
    public BaseBillDTO imageCount(Integer imageCount) {
        this.imageCount = imageCount;
        return this;
    }

    /**
     * 已有影像张数
     *
     * @return imageCount
     **/
    @ApiModelProperty(value = "已有影像张数")
    public Integer getImageCount() {
        return imageCount;
    }

    public void setImageCount(Integer imageCount) {
        this.imageCount = imageCount;
    }

    @JsonIgnore
    public BaseBillDTO exceptionCount(Integer exceptionCount) {
        this.exceptionCount = exceptionCount;
        return this;
    }

    /**
     * 异常数
     *
     * @return exceptionCount
     **/
    @ApiModelProperty(value = "异常数")
    public Integer getExceptionCount() {
        return exceptionCount;
    }

    public void setExceptionCount(Integer exceptionCount) {
        this.exceptionCount = exceptionCount;
    }

    @JsonIgnore
    public BaseBillDTO warningCount(Integer warningCount) {
        this.warningCount = warningCount;
        return this;
    }

    /**
     * 预警数
     *
     * @return warningCount
     **/
    @ApiModelProperty(value = "预警数")
    public Integer getWarningCount() {
        return warningCount;
    }

    public void setWarningCount(Integer warningCount) {
        this.warningCount = warningCount;
    }

    @JsonIgnore
    public BaseBillDTO isException(Integer isException) {
        this.isException = isException;
        return this;
    }

    /**
     * 单据是否异常 0-否 1-是
     *
     * @return isException
     **/
    @ApiModelProperty(value = "单据是否异常 0-否 1-是")
    public Integer getIsException() {
        return isException;
    }

    public void setIsException(Integer isException) {
        this.isException = isException;
    }

    @JsonIgnore
    public BaseBillDTO exceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    /**
     * 单据异常信息
     *
     * @return exceptionInfo
     **/
    @ApiModelProperty(value = "单据异常信息")
    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    @JsonIgnore
    public BaseBillDTO createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public BaseBillDTO createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public BaseBillDTO createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public BaseBillDTO updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public BaseBillDTO updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public BaseBillDTO updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @JsonIgnore
    public BaseBillDTO systemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
        return this;
    }

    /**
     * 系统来源
     *
     * @return systemOrig
     **/
    @ApiModelProperty(value = "系统来源")
    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    @JsonIgnore
    public BaseBillDTO backRemark(String backRemark) {
        this.backRemark = backRemark;
        return this;
    }

    /**
     * 退回备注
     *
     * @return backRemark
     **/
    @ApiModelProperty(value = "退回备注")
    public String getBackRemark() {
        return backRemark;
    }

    public void setBackRemark(String backRemark) {
        this.backRemark = backRemark;
    }

    @JsonIgnore
    public BaseBillDTO unqualityType(Integer unqualityType) {
        this.unqualityType = unqualityType;
        return this;
    }

    /**
     * 核验不合格类型：
     *
     * @return unqualityType
     **/
    @ApiModelProperty(value = "核验不合格类型：")
    public Integer getUnqualityType() {
        return unqualityType;
    }

    public void setUnqualityType(Integer unqualityType) {
        this.unqualityType = unqualityType;
    }

    @JsonIgnore
    public BaseBillDTO unqualityReason(String unqualityReason) {
        this.unqualityReason = unqualityReason;
        return this;
    }

    /**
     * 核验不合格原因
     *
     * @return unqualityReason
     **/
    @ApiModelProperty(value = "核验不合格原因")
    public String getUnqualityReason() {
        return unqualityReason;
    }

    public void setUnqualityReason(String unqualityReason) {
        this.unqualityReason = unqualityReason;
    }

    @JsonIgnore
    public BaseBillDTO verifyHangType(Integer verifyHangType) {
        this.verifyHangType = verifyHangType;
        return this;
    }

    /**
     * 核验挂起原因
     *
     * @return verifyHangType
     **/
    @ApiModelProperty(value = "核验挂起原因")
    public Integer getVerifyHangType() {
        return verifyHangType;
    }

    public void setVerifyHangType(Integer verifyHangType) {
        this.verifyHangType = verifyHangType;
    }

    @JsonIgnore
    public BaseBillDTO verifyHangReason(String verifyHangReason) {
        this.verifyHangReason = verifyHangReason;
        return this;
    }

    /**
     * 核验挂起备注
     *
     * @return verifyHangReason
     **/
    @ApiModelProperty(value = "核验挂起备注")
    public String getVerifyHangReason() {
        return verifyHangReason;
    }

    public void setVerifyHangReason(String verifyHangReason) {
        this.verifyHangReason = verifyHangReason;
    }

    @JsonIgnore
    public BaseBillDTO isPrepayment(Integer isPrepayment) {
        this.isPrepayment = isPrepayment;
        return this;
    }

    /**
     * 是否预付款
     *
     * @return isPrepayment
     **/
    @ApiModelProperty(value = "是否预付款")
    public Integer getIsPrepayment() {
        return isPrepayment;
    }

    public void setIsPrepayment(Integer isPrepayment) {
        this.isPrepayment = isPrepayment;
    }

    @JsonIgnore
    public BaseBillDTO extFields(String extFields) {
        this.extFields = extFields;
        return this;
    }

    /**
     * 扩展字段
     *
     * @return extFields
     **/
    @ApiModelProperty(value = "扩展字段")
    public String getExtFields() {
        return extFields;
    }

    public void setExtFields(String extFields) {
        this.extFields = extFields;
    }

    @JsonIgnore
    public BaseBillDTO extStatus(Integer extStatus) {
        this.extStatus = extStatus;
        return this;
    }

    /**
     * 外部状态
     *
     * @return extStatus
     **/
    @ApiModelProperty(value = "外部状态")
    public Integer getExtStatus() {
        return extStatus;
    }

    public void setExtStatus(Integer extStatus) {
        this.extStatus = extStatus;
    }

    @JsonIgnore
    public BaseBillDTO prepaymentStatus(Integer prepaymentStatus) {
        this.prepaymentStatus = prepaymentStatus;
        return this;
    }

    /**
     * 预付款状态
     *
     * @return prepaymentStatus
     **/
    @ApiModelProperty(value = "预付款状态")
    public Integer getPrepaymentStatus() {
        return prepaymentStatus;
    }

    public void setPrepaymentStatus(Integer prepaymentStatus) {
        this.prepaymentStatus = prepaymentStatus;
    }

    @JsonIgnore
    public BaseBillDTO prepaymentTime(Long prepaymentTime) {
        this.prepaymentTime = prepaymentTime;
        return this;
    }

    /**
     * 预付款变更时间
     *
     * @return prepaymentTime
     **/
    @ApiModelProperty(value = "预付款变更时间")
    public Long getPrepaymentTime() {
        return prepaymentTime;
    }

    public void setPrepaymentTime(Long prepaymentTime) {
        this.prepaymentTime = prepaymentTime;
    }

    @JsonIgnore
    public BaseBillDTO macthStatus(Integer macthStatus) {
        this.macthStatus = macthStatus;
        return this;
    }

    /**
     * 匹配状态
     *
     * @return macthStatus
     **/
    @ApiModelProperty(value = "匹配状态")
    public Integer getMacthStatus() {
        return macthStatus;
    }

    public void setMacthStatus(Integer macthStatus) {
        this.macthStatus = macthStatus;
    }

    @JsonIgnore
    public BaseBillDTO createUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
        return this;
    }

    /**
     * 创建用户代码
     *
     * @return createUserCode
     **/
    @ApiModelProperty(value = "创建用户代码")
    public String getCreateUserCode() {
        return createUserCode;
    }

    public void setCreateUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
    }

    @JsonIgnore
    public BaseBillDTO sellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
        return this;
    }

    /**
     * 销方税号
     *
     * @return sellerTaxNo
     **/
    @ApiModelProperty(value = "销方税号")
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    @JsonIgnore
    public BaseBillDTO sellerName(String sellerName) {
        this.sellerName = sellerName;
        return this;
    }

    /**
     * 销方名称
     *
     * @return sellerName
     **/
    @ApiModelProperty(value = "销方名称")
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    @JsonIgnore
    public BaseBillDTO purchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
        return this;
    }

    /**
     * 购方税号
     *
     * @return purchaserTaxNo
     **/
    @ApiModelProperty(value = "购方税号")
    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    @JsonIgnore
    public BaseBillDTO purchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
        return this;
    }

    /**
     * 购方名称
     *
     * @return purchaserName
     **/
    @ApiModelProperty(value = "购方名称")
    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    @JsonIgnore
    public BaseBillDTO serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    /**
     * 流水号
     *
     * @return serialNumber
     **/
    @ApiModelProperty(value = "流水号")
    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @JsonIgnore
    public BaseBillDTO billCheckStatus(Integer billCheckStatus) {
        this.billCheckStatus = billCheckStatus;
        return this;
    }

    /**
     * 单据校验状态
     *
     * @return billCheckStatus
     **/
    @ApiModelProperty(value = "单据校验状态")
    public Integer getBillCheckStatus() {
        return billCheckStatus;
    }

    public void setBillCheckStatus(Integer billCheckStatus) {
        this.billCheckStatus = billCheckStatus;
    }

    @JsonIgnore
    public BaseBillDTO purchaserCode(String purchaserCode) {
        this.purchaserCode = purchaserCode;
        return this;
    }

    /**
     * 购方代码
     *
     * @return purchaserCode
     **/
    @ApiModelProperty(value = "购方代码")
    public String getPurchaserCode() {
        return purchaserCode;
    }

    public void setPurchaserCode(String purchaserCode) {
        this.purchaserCode = purchaserCode;
    }

    @JsonIgnore
    public BaseBillDTO billCheckTime(Long billCheckTime) {
        this.billCheckTime = billCheckTime;
        return this;
    }

    /**
     * 单据校验状态变更时间
     *
     * @return billCheckTime
     **/
    @ApiModelProperty(value = "单据校验状态变更时间")
    public Long getBillCheckTime() {
        return billCheckTime;
    }

    public void setBillCheckTime(Long billCheckTime) {
        this.billCheckTime = billCheckTime;
    }

    @JsonIgnore
    public BaseBillDTO remark(String remark) {
        this.remark = remark;
        return this;
    }

    /**
     * 备注
     *
     * @return remark
     **/
    @ApiModelProperty(value = "备注")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @JsonIgnore
    public BaseBillDTO sellerCode(String sellerCode) {
        this.sellerCode = sellerCode;
        return this;
    }

    /**
     * 销方代码
     *
     * @return sellerCode
     **/
    @ApiModelProperty(value = "销方代码")
    public String getSellerCode() {
        return sellerCode;
    }

    public void setSellerCode(String sellerCode) {
        this.sellerCode = sellerCode;
    }

    @JsonIgnore
    public BaseBillDTO reserved1(String reserved1) {
        this.reserved1 = reserved1;
        return this;
    }

    /**
     * 保留字段
     *
     * @return reserved1
     **/
    @ApiModelProperty(value = "保留字段")
    public String getReserved1() {
        return reserved1;
    }

    public void setReserved1(String reserved1) {
        this.reserved1 = reserved1;
    }

    @JsonIgnore
    public BaseBillDTO reserved2(String reserved2) {
        this.reserved2 = reserved2;
        return this;
    }

    /**
     * 保留字段
     *
     * @return reserved2
     **/
    @ApiModelProperty(value = "保留字段")
    public String getReserved2() {
        return reserved2;
    }

    public void setReserved2(String reserved2) {
        this.reserved2 = reserved2;
    }

    @JsonIgnore
    public BaseBillDTO reserved3(String reserved3) {
        this.reserved3 = reserved3;
        return this;
    }

    /**
     * 保留字段
     *
     * @return reserved3
     **/
    @ApiModelProperty(value = "保留字段")
    public String getReserved3() {
        return reserved3;
    }

    public void setReserved3(String reserved3) {
        this.reserved3 = reserved3;
    }

    @JsonIgnore
    public BaseBillDTO isCommit(Integer isCommit) {
        this.isCommit = isCommit;
        return this;
    }

    /**
     * 是否提交:0-否,1-是
     *
     * @return isCommit
     **/
    @ApiModelProperty(value = "是否提交:0-否,1-是")
    public Integer getIsCommit() {
        return isCommit;
    }

    public void setIsCommit(Integer isCommit) {
        this.isCommit = isCommit;
    }

    @JsonIgnore
    public BaseBillDTO commitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
        return this;
    }

    /**
     * 提交人ID
     *
     * @return commitUserId
     **/
    @ApiModelProperty(value = "提交人ID")
    public Long getCommitUserId() {
        return commitUserId;
    }

    public void setCommitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
    }

    @JsonIgnore
    public BaseBillDTO commitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
        return this;
    }

    /**
     * 提交人姓名
     *
     * @return commitUserName
     **/
    @ApiModelProperty(value = "提交人姓名")
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    @JsonIgnore
    public BaseBillDTO commitTime(Long commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    /**
     * 提交时间
     *
     * @return commitTime
     **/
    @ApiModelProperty(value = "提交时间")
    public Long getCommitTime() {
        return commitTime;
    }

    public void setCommitTime(Long commitTime) {
        this.commitTime = commitTime;
    }

    @JsonIgnore
    public BaseBillDTO businessType(String businessType) {
        this.businessType = businessType;
        return this;
    }

    /**
     * 业务子类型
     *
     * @return businessType
     **/
    @ApiModelProperty(value = "业务子类型")
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @JsonIgnore
    public BaseBillDTO billUse(String billUse) {
        this.billUse = billUse;
        return this;
    }

    /**
     * 单据用途
     *
     * @return billUse
     **/
    @ApiModelProperty(value = "单据用途")
    public String getBillUse() {
        return billUse;
    }

    public void setBillUse(String billUse) {
        this.billUse = billUse;
    }

    @JsonIgnore
    public BaseBillDTO businessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
        return this;
    }

    /**
     * 业务子类型名称
     *
     * @return businessTypeName
     **/
    @ApiModelProperty(value = "业务子类型名称")
    public String getBusinessTypeName() {
        return businessTypeName;
    }

    public void setBusinessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseBillDTO baseBillDTO = (BaseBillDTO) o;
        return Objects.equals(this.id, baseBillDTO.id) &&
            Objects.equals(this.tenantId, baseBillDTO.tenantId) &&
            Objects.equals(this.imageId, baseBillDTO.imageId) &&
            Objects.equals(this.batchNo, baseBillDTO.batchNo) &&
            Objects.equals(this.billTypeCode, baseBillDTO.billTypeCode) &&
            Objects.equals(this.billTypeName, baseBillDTO.billTypeName) &&
            Objects.equals(this.billCode, baseBillDTO.billCode) &&
            Objects.equals(this.billAmountWithTax, baseBillDTO.billAmountWithTax) &&
            Objects.equals(this.billTaxAmount, baseBillDTO.billTaxAmount) &&
            Objects.equals(this.billAmountWithoutTax, baseBillDTO.billAmountWithoutTax) &&
            Objects.equals(this.billCreateUser, baseBillDTO.billCreateUser) &&
            Objects.equals(this.billCreateTime, baseBillDTO.billCreateTime) &&
            Objects.equals(this.scanUserId, baseBillDTO.scanUserId) &&
            Objects.equals(this.scanUserName, baseBillDTO.scanUserName) &&
            Objects.equals(this.scanCreateTime, baseBillDTO.scanCreateTime) &&
            Objects.equals(this.packageCode, baseBillDTO.packageCode) &&
            Objects.equals(this.logisticsStatus, baseBillDTO.logisticsStatus) &&
            Objects.equals(this.logisticsTime, baseBillDTO.logisticsTime) &&
            Objects.equals(this.logisticRemark, baseBillDTO.logisticRemark) &&
            Objects.equals(this.signStatus, baseBillDTO.signStatus) &&
            Objects.equals(this.signTime, baseBillDTO.signTime) &&
            Objects.equals(this.isPublic, baseBillDTO.isPublic) &&
            Objects.equals(this.isSecret, baseBillDTO.isSecret) &&
            Objects.equals(this.hangType, baseBillDTO.hangType) &&
            Objects.equals(this.hangReason, baseBillDTO.hangReason) &&
            Objects.equals(this.hangTime, baseBillDTO.hangTime) &&
            Objects.equals(this.backType, baseBillDTO.backType) &&
            Objects.equals(this.backReason, baseBillDTO.backReason) &&
            Objects.equals(this.billDataStatus, baseBillDTO.billDataStatus) &&
            Objects.equals(this.billDataTime, baseBillDTO.billDataTime) &&
            Objects.equals(this.verifyStatus, baseBillDTO.verifyStatus) &&
            Objects.equals(this.verifyTime, baseBillDTO.verifyTime) &&
            Objects.equals(this.ticketCount, baseBillDTO.ticketCount) &&
            Objects.equals(this.imageCount, baseBillDTO.imageCount) &&
            Objects.equals(this.exceptionCount, baseBillDTO.exceptionCount) &&
            Objects.equals(this.warningCount, baseBillDTO.warningCount) &&
            Objects.equals(this.isException, baseBillDTO.isException) &&
            Objects.equals(this.exceptionInfo, baseBillDTO.exceptionInfo) &&
            Objects.equals(this.createTime, baseBillDTO.createTime) &&
            Objects.equals(this.createUserId, baseBillDTO.createUserId) &&
            Objects.equals(this.createUserName, baseBillDTO.createUserName) &&
            Objects.equals(this.updateTime, baseBillDTO.updateTime) &&
            Objects.equals(this.updateUserId, baseBillDTO.updateUserId) &&
            Objects.equals(this.updateUserName, baseBillDTO.updateUserName) &&
            Objects.equals(this.systemOrig, baseBillDTO.systemOrig) &&
            Objects.equals(this.backRemark, baseBillDTO.backRemark) &&
            Objects.equals(this.unqualityType, baseBillDTO.unqualityType) &&
            Objects.equals(this.unqualityReason, baseBillDTO.unqualityReason) &&
            Objects.equals(this.verifyHangType, baseBillDTO.verifyHangType) &&
            Objects.equals(this.verifyHangReason, baseBillDTO.verifyHangReason) &&
            Objects.equals(this.isPrepayment, baseBillDTO.isPrepayment) &&
            Objects.equals(this.extFields, baseBillDTO.extFields) &&
            Objects.equals(this.extStatus, baseBillDTO.extStatus) &&
            Objects.equals(this.prepaymentStatus, baseBillDTO.prepaymentStatus) &&
            Objects.equals(this.prepaymentTime, baseBillDTO.prepaymentTime) &&
            Objects.equals(this.macthStatus, baseBillDTO.macthStatus) &&
            Objects.equals(this.createUserCode, baseBillDTO.createUserCode) &&
            Objects.equals(this.sellerTaxNo, baseBillDTO.sellerTaxNo) &&
            Objects.equals(this.sellerName, baseBillDTO.sellerName) &&
            Objects.equals(this.purchaserTaxNo, baseBillDTO.purchaserTaxNo) &&
            Objects.equals(this.purchaserName, baseBillDTO.purchaserName) &&
            Objects.equals(this.serialNumber, baseBillDTO.serialNumber) &&
            Objects.equals(this.billCheckStatus, baseBillDTO.billCheckStatus) &&
            Objects.equals(this.purchaserCode, baseBillDTO.purchaserCode) &&
            Objects.equals(this.billCheckTime, baseBillDTO.billCheckTime) &&
            Objects.equals(this.remark, baseBillDTO.remark) &&
            Objects.equals(this.sellerCode, baseBillDTO.sellerCode) &&
            Objects.equals(this.reserved1, baseBillDTO.reserved1) &&
            Objects.equals(this.reserved2, baseBillDTO.reserved2) &&
            Objects.equals(this.reserved3, baseBillDTO.reserved3) &&
            Objects.equals(this.isCommit, baseBillDTO.isCommit) &&
            Objects.equals(this.commitUserId, baseBillDTO.commitUserId) &&
            Objects.equals(this.commitUserName, baseBillDTO.commitUserName) &&
            Objects.equals(this.commitTime, baseBillDTO.commitTime) &&
            Objects.equals(this.businessType, baseBillDTO.businessType) &&
            Objects.equals(this.billUse, baseBillDTO.billUse) &&
            Objects.equals(this.businessTypeName, baseBillDTO.businessTypeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, tenantId, imageId, batchNo, billTypeCode, billTypeName, billCode, billAmountWithTax, billTaxAmount, billAmountWithoutTax, billCreateUser, billCreateTime, scanUserId,
            scanUserName, scanCreateTime, packageCode, logisticsStatus, logisticsTime, logisticRemark, signStatus, signTime, isPublic, isSecret, hangType, hangReason, hangTime, backType, backReason,
            billDataStatus, billDataTime, verifyStatus, verifyTime, ticketCount, imageCount, exceptionCount, warningCount, isException, exceptionInfo, createTime, createUserId, createUserName,
            updateTime, updateUserId, updateUserName, systemOrig, backRemark, unqualityType, unqualityReason, verifyHangType, verifyHangReason, isPrepayment, extFields, extStatus, prepaymentStatus,
            prepaymentTime, macthStatus, createUserCode, sellerTaxNo, sellerName, purchaserTaxNo, purchaserName, serialNumber, billCheckStatus, purchaserCode, billCheckTime, remark, sellerCode,
            reserved1, reserved2, reserved3, isCommit, commitUserId, commitUserName, commitTime, businessType, billUse, businessTypeName);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseBillDTO {\n");

        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
        sb.append("    billTypeCode: ").append(toIndentedString(billTypeCode)).append("\n");
        sb.append("    billTypeName: ").append(toIndentedString(billTypeName)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    billAmountWithTax: ").append(toIndentedString(billAmountWithTax)).append("\n");
        sb.append("    billTaxAmount: ").append(toIndentedString(billTaxAmount)).append("\n");
        sb.append("    billAmountWithoutTax: ").append(toIndentedString(billAmountWithoutTax)).append("\n");
        sb.append("    billCreateUser: ").append(toIndentedString(billCreateUser)).append("\n");
        sb.append("    billCreateTime: ").append(toIndentedString(billCreateTime)).append("\n");
        sb.append("    scanUserId: ").append(toIndentedString(scanUserId)).append("\n");
        sb.append("    scanUserName: ").append(toIndentedString(scanUserName)).append("\n");
        sb.append("    scanCreateTime: ").append(toIndentedString(scanCreateTime)).append("\n");
        sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
        sb.append("    logisticsStatus: ").append(toIndentedString(logisticsStatus)).append("\n");
        sb.append("    logisticsTime: ").append(toIndentedString(logisticsTime)).append("\n");
        sb.append("    logisticRemark: ").append(toIndentedString(logisticRemark)).append("\n");
        sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
        sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
        sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
        sb.append("    isSecret: ").append(toIndentedString(isSecret)).append("\n");
        sb.append("    hangType: ").append(toIndentedString(hangType)).append("\n");
        sb.append("    hangReason: ").append(toIndentedString(hangReason)).append("\n");
        sb.append("    hangTime: ").append(toIndentedString(hangTime)).append("\n");
        sb.append("    backType: ").append(toIndentedString(backType)).append("\n");
        sb.append("    backReason: ").append(toIndentedString(backReason)).append("\n");
        sb.append("    billDataStatus: ").append(toIndentedString(billDataStatus)).append("\n");
        sb.append("    billDataTime: ").append(toIndentedString(billDataTime)).append("\n");
        sb.append("    verifyStatus: ").append(toIndentedString(verifyStatus)).append("\n");
        sb.append("    verifyTime: ").append(toIndentedString(verifyTime)).append("\n");
        sb.append("    ticketCount: ").append(toIndentedString(ticketCount)).append("\n");
        sb.append("    imageCount: ").append(toIndentedString(imageCount)).append("\n");
        sb.append("    exceptionCount: ").append(toIndentedString(exceptionCount)).append("\n");
        sb.append("    warningCount: ").append(toIndentedString(warningCount)).append("\n");
        sb.append("    isException: ").append(toIndentedString(isException)).append("\n");
        sb.append("    exceptionInfo: ").append(toIndentedString(exceptionInfo)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
        sb.append("    backRemark: ").append(toIndentedString(backRemark)).append("\n");
        sb.append("    unqualityType: ").append(toIndentedString(unqualityType)).append("\n");
        sb.append("    unqualityReason: ").append(toIndentedString(unqualityReason)).append("\n");
        sb.append("    verifyHangType: ").append(toIndentedString(verifyHangType)).append("\n");
        sb.append("    verifyHangReason: ").append(toIndentedString(verifyHangReason)).append("\n");
        sb.append("    isPrepayment: ").append(toIndentedString(isPrepayment)).append("\n");
        sb.append("    extFields: ").append(toIndentedString(extFields)).append("\n");
        sb.append("    extStatus: ").append(toIndentedString(extStatus)).append("\n");
        sb.append("    prepaymentStatus: ").append(toIndentedString(prepaymentStatus)).append("\n");
        sb.append("    prepaymentTime: ").append(toIndentedString(prepaymentTime)).append("\n");
        sb.append("    macthStatus: ").append(toIndentedString(macthStatus)).append("\n");
        sb.append("    createUserCode: ").append(toIndentedString(createUserCode)).append("\n");
        sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
        sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
        sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
        sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
        sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
        sb.append("    billCheckStatus: ").append(toIndentedString(billCheckStatus)).append("\n");
        sb.append("    purchaserCode: ").append(toIndentedString(purchaserCode)).append("\n");
        sb.append("    billCheckTime: ").append(toIndentedString(billCheckTime)).append("\n");
        sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
        sb.append("    sellerCode: ").append(toIndentedString(sellerCode)).append("\n");
        sb.append("    reserved1: ").append(toIndentedString(reserved1)).append("\n");
        sb.append("    reserved2: ").append(toIndentedString(reserved2)).append("\n");
        sb.append("    reserved3: ").append(toIndentedString(reserved3)).append("\n");
        sb.append("    isCommit: ").append(toIndentedString(isCommit)).append("\n");
        sb.append("    commitUserId: ").append(toIndentedString(commitUserId)).append("\n");
        sb.append("    commitUserName: ").append(toIndentedString(commitUserName)).append("\n");
        sb.append("    commitTime: ").append(toIndentedString(commitTime)).append("\n");
        sb.append("    businessType: ").append(toIndentedString(businessType)).append("\n");
        sb.append("    billUse: ").append(toIndentedString(billUse)).append("\n");
        sb.append("    businessTypeName: ").append(toIndentedString(businessTypeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getTicketException() {
        return ticketException;
    }

    public void setTicketException(String ticketException) {
        this.ticketException = ticketException;
    }

    public String getTicketWarning() {
        return ticketWarning;
    }

    public void setTicketWarning(String ticketWarning) {
        this.ticketWarning = ticketWarning;
    }

}
