package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 校验岗单据退回重扫
 */
@ApiModel(description = "校验岗单据退回重扫")

@JsonInclude(NON_NULL)
public class CheckBillBackReScanRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("backReason")
    private String backReason = null;

    @JsonIgnore
    public CheckBillBackReScanRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public CheckBillBackReScanRequest backReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    /**
     * 退回原因
     *
     * @return backReason
     **/
    @ApiModelProperty(value = "退回原因")
    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckBillBackReScanRequest checkBillBackReScanRequest = (CheckBillBackReScanRequest) o;
        return Objects.equals(this.billCode, checkBillBackReScanRequest.billCode) &&
            Objects.equals(this.backReason, checkBillBackReScanRequest.backReason) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, backReason, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckBillBackReScanRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    backReason: ").append(toIndentedString(backReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
