package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 批量单证池发票影像Request
 */
@ApiModel(description = "批量单证池发票影像Request")

@JsonInclude(NON_NULL)
public class DeleteTicketListRequest extends BaseRequest {

    @JsonProperty("ticketIds")
    private List<Long> ticketIds = new ArrayList<Long>();

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonIgnore
    public DeleteTicketListRequest ticketIds(List<Long> ticketIds) {
        this.ticketIds = ticketIds;
        return this;
    }

    public DeleteTicketListRequest addTicketIdsItem(Long ticketIdsItem) {
        this.ticketIds.add(ticketIdsItem);
        return this;
    }

    /**
     * 单证ID集合
     *
     * @return ticketIds
     **/
    @ApiModelProperty(value = "单证ID集合")
    public List<Long> getTicketIds() {
        return ticketIds;
    }

    public void setTicketIds(List<Long> ticketIds) {
        this.ticketIds = ticketIds;
    }

    @JsonIgnore
    public DeleteTicketListRequest ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 单证code
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "单证code")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeleteTicketListRequest deleteTicketListRequest = (DeleteTicketListRequest) o;
        return Objects.equals(this.ticketIds, deleteTicketListRequest.ticketIds) &&
            Objects.equals(this.ticketCode, deleteTicketListRequest.ticketCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketIds, ticketCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteTicketListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    ticketIds: ").append(toIndentedString(ticketIds)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
