package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Request
 */
@ApiModel(description = "Request")

@JsonInclude(NON_NULL)
public class GetLogMqListRequest extends PageRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("sender")
    private String sender = null;

    @JsonProperty("listener")
    private String listener = null;

    @JsonProperty("queueName")
    private String queueName = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("finishTime")
    private List<Long> finishTime = new ArrayList<Long>();

    @JsonProperty("params")
    private String params = null;

    @JsonIgnore
    public GetLogMqListRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public GetLogMqListRequest ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 票证号
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "票证号")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }

    @JsonIgnore
    public GetLogMqListRequest sender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * 发送方
     *
     * @return sender
     **/
    @ApiModelProperty(value = "发送方")
    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    @JsonIgnore
    public GetLogMqListRequest listener(String listener) {
        this.listener = listener;
        return this;
    }

    /**
     * 监听方
     *
     * @return listener
     **/
    @ApiModelProperty(value = "监听方")
    public String getListener() {
        return listener;
    }

    public void setListener(String listener) {
        this.listener = listener;
    }

    @JsonIgnore
    public GetLogMqListRequest queueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    /**
     * 队列名
     *
     * @return queueName
     **/
    @ApiModelProperty(value = "队列名")
    public String getQueueName() {
        return queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @JsonIgnore
    public GetLogMqListRequest status(Integer status) {
        this.status = status;
        return this;
    }

    /**
     * 状态：1-成功，0-失败
     *
     * @return status
     **/
    @ApiModelProperty(value = "状态：1-成功，0-失败")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonIgnore
    public GetLogMqListRequest finishTime(List<Long> finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    public GetLogMqListRequest addFinishTimeItem(Long finishTimeItem) {
        this.finishTime.add(finishTimeItem);
        return this;
    }

    /**
     * 创建时间
     *
     * @return finishTime
     **/
    @ApiModelProperty(value = "创建时间")
    public List<Long> getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(List<Long> finishTime) {
        this.finishTime = finishTime;
    }

    @JsonIgnore
    public GetLogMqListRequest params(String params) {
        this.params = params;
        return this;
    }

    /**
     * 请求参数
     *
     * @return params
     **/
    @ApiModelProperty(value = "请求参数")
    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetLogMqListRequest getLogMqListRequest = (GetLogMqListRequest) o;
        return Objects.equals(this.billCode, getLogMqListRequest.billCode) &&
            Objects.equals(this.ticketCode, getLogMqListRequest.ticketCode) &&
            Objects.equals(this.sender, getLogMqListRequest.sender) &&
            Objects.equals(this.listener, getLogMqListRequest.listener) &&
            Objects.equals(this.queueName, getLogMqListRequest.queueName) &&
            Objects.equals(this.status, getLogMqListRequest.status) &&
            Objects.equals(this.finishTime, getLogMqListRequest.finishTime) &&
            Objects.equals(this.params, getLogMqListRequest.params) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, ticketCode, sender, listener, queueName, status, finishTime, params, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetLogMqListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
        sb.append("    listener: ").append(toIndentedString(listener)).append("\n");
        sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    finishTime: ").append(toIndentedString(finishTime)).append("\n");
        sb.append("    params: ").append(toIndentedString(params)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
