package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 影像退回表
 */
@ApiModel(description = "影像退回表")

@JsonInclude(NON_NULL)
public class ImageReturnDTO {

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("returnType")
    private String returnType = null;

    @JsonProperty("returnReason")
    private String returnReason = null;

    @JsonProperty("returnRemark")
    private String returnRemark = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("operateType")
    private Integer operateType = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("invoiceSheet")
    private String invoiceSheet = null;

    @JsonProperty("beforeStatus")
    private String beforeStatus = null;

    @JsonIgnore
    public ImageReturnDTO id(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 自增主键
     *
     * @return id
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public ImageReturnDTO tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public ImageReturnDTO returnType(String returnType) {
        this.returnType = returnType;
        return this;
    }

    /**
     * 退回类型：1-审批驳回，2-核验退回
     *
     * @return returnType
     **/
    @ApiModelProperty(value = "退回类型：1-审批驳回，2-核验退回")
    public String getReturnType() {
        return returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @JsonIgnore
    public ImageReturnDTO returnReason(String returnReason) {
        this.returnReason = returnReason;
        return this;
    }

    /**
     * 退回原因：1-数据问题，2-金额有误
     *
     * @return returnReason
     **/
    @ApiModelProperty(value = "退回原因：1-数据问题，2-金额有误")
    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    @JsonIgnore
    public ImageReturnDTO returnRemark(String returnRemark) {
        this.returnRemark = returnRemark;
        return this;
    }

    /**
     * 退回备注
     *
     * @return returnRemark
     **/
    @ApiModelProperty(value = "退回备注")
    public String getReturnRemark() {
        return returnRemark;
    }

    public void setReturnRemark(String returnRemark) {
        this.returnRemark = returnRemark;
    }

    @JsonIgnore
    public ImageReturnDTO createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public ImageReturnDTO createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public ImageReturnDTO createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    public Integer getOperateType() {
        return operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceSheet() {
        return invoiceSheet;
    }

    public void setInvoiceSheet(String invoiceSheet) {
        this.invoiceSheet = invoiceSheet;
    }

    public String getBeforeStatus() {
        return beforeStatus;
    }

    public void setBeforeStatus(String beforeStatus) {
        this.beforeStatus = beforeStatus;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImageReturnDTO imageReturnDTO = (ImageReturnDTO) o;
        return Objects.equals(this.id, imageReturnDTO.id) &&
            Objects.equals(this.tenantId, imageReturnDTO.tenantId) &&
            Objects.equals(this.returnType, imageReturnDTO.returnType) &&
            Objects.equals(this.returnReason, imageReturnDTO.returnReason) &&
            Objects.equals(this.returnRemark, imageReturnDTO.returnRemark) &&
            Objects.equals(this.createTime, imageReturnDTO.createTime) &&
            Objects.equals(this.createUserId, imageReturnDTO.createUserId) &&
            Objects.equals(this.createUserName, imageReturnDTO.createUserName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, tenantId, returnType, returnReason, returnRemark, createTime, createUserId, createUserName);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageReturnDTO {\n");

        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    returnType: ").append(toIndentedString(returnType)).append("\n");
        sb.append("    returnReason: ").append(toIndentedString(returnReason)).append("\n");
        sb.append("    returnRemark: ").append(toIndentedString(returnRemark)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
